/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import nl.ctrlaltdev.ui.Build;
import nl.moj.client.anim.Anim;
import nl.moj.client.anim.AnimPlayer;

public class TestSetPanel
extends JPanel {
    private static final Font MONOSPACEFONT = new Font("Monospaced", 0, 11);
    private JTree testSetTree = new JTree();
    private JTextArea descriptionText;
    private JList consoleOutput;
    private JLabel descriptionLabel;
    private JPanel testResultIndicator;
    private JLabel outputLabel;
    private AnimPlayer animPlayer;
    private TestCase[] testCases;
    private TestCase selected;

    public TestSetPanel(Icon ok, Icon unknown, Icon failed) {
        super(new BorderLayout());
        this.testSetTree.setCellRenderer(new TestCaseTreeRenderer(ok, unknown, failed));
        this.descriptionText = new JTextArea();
        this.descriptionText.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.descriptionText.setEditable(false);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setFont(MONOSPACEFONT);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setPreferredSize(new Dimension(128, 24));
        this.descriptionLabel.setHorizontalAlignment(4);
        this.testResultIndicator = new JPanel();
        this.testResultIndicator.setPreferredSize(new Dimension(64, 24));
        this.testResultIndicator.setBorder(BorderFactory.createBevelBorder(1));
        this.testResultIndicator.setBackground(Color.yellow);
        this.animPlayer = new AnimPlayer();
        this.animPlayer.setPreferredSize(new Dimension(200, 200));
        this.consoleOutput = new JList();
        this.consoleOutput.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.outputLabel = new JLabel("Output");
        this.outputLabel.setPreferredSize(new Dimension(128, 24));
        this.outputLabel.setHorizontalAlignment(4);
        JScrollPane treeScrollPane = new JScrollPane(this.testSetTree);
        treeScrollPane.setPreferredSize(new Dimension(128, 256));
        this.add((Component)treeScrollPane, "West");
        this.add((Component)new Build.BOXY(new JComponent[]{new Build.WCE(new Build.NBOXY(new JComponent[]{new Build.RFP(this.descriptionLabel), new Build.RFP(this.testResultIndicator)}), new JScrollPane(this.descriptionText), null), new Build.WCE(new Build.NBOXY(new JComponent[]{new Build.RFP(this.outputLabel)}), new JScrollPane(this.consoleOutput), this.animPlayer)}), "Center");
        this.testSetTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                for (int t = 0; t < TestSetPanel.this.testCases.length; ++t) {
                    if (!TestSetPanel.this.testCases[t].equals(tn.getUserObject())) continue;
                    TestSetPanel.this.selectTestCase(TestSetPanel.this.testCases[t]);
                }
            }
        });
    }

    public void setTestCases(String[] labels, String[] descriptions) {
        this.testCases = new TestCase[labels.length];
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("TestSet");
        for (int t = 0; t < labels.length; ++t) {
            this.testCases[t] = new TestCase(labels[t], descriptions[t]);
            root.add(new DefaultMutableTreeNode(this.testCases[t]));
        }
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.testSetTree.setModel(dtm);
        this.testSetTree.setSelectionRow(1);
    }

    public void clearResults() {
        for (int t = 0; t < this.testCases.length; ++t) {
            this.testCases[t].reset();
        }
    }

    public void setResults(int[] results) {
        for (int t = 0; t < this.testCases.length; ++t) {
            this.testCases[t].result = results.length != this.testCases.length ? 0 : results[t];
        }
        this.selectTestCase(this.selected);
    }

    public void setAnimation(int testCase, Anim animation) {
        this.testCases[testCase].animation = animation;
        if (this.testCases[testCase].equals(this.selected)) {
            this.animPlayer.setAnimation(animation);
        }
    }

    public void addToConsole(int testCase, String line) {
        this.testCases[testCase].console.addElement(line);
    }

    protected void selectTestCase(TestCase idx) {
        if (idx == null) {
            return;
        }
        this.descriptionText.setText(idx.description);
        this.descriptionLabel.setText(idx.label);
        this.consoleOutput.setModel(idx.console);
        this.animPlayer.setAnimation(idx.animation);
        switch (idx.result) {
            case -1: {
                this.testResultIndicator.setBackground(Color.red);
                break;
            }
            case 0: {
                this.testResultIndicator.setBackground(Color.yellow);
                break;
            }
            case 1: {
                this.testResultIndicator.setBackground(Color.green);
            }
        }
        this.selected = idx;
    }

    public class TestCaseTreeRenderer
    extends DefaultTreeCellRenderer {
        private Icon okIcon;
        private Icon unknownIcon;
        private Icon failedIcon;

        public TestCaseTreeRenderer(Icon ok, Icon unknown, Icon failed) {
            this.okIcon = ok;
            this.unknownIcon = unknown;
            this.failedIcon = failed;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            value = ((DefaultMutableTreeNode)value).getUserObject();
            if (value instanceof TestCase) {
                switch (((TestCase)value).result) {
                    case -1: {
                        this.setIcon(this.failedIcon);
                        this.setToolTipText("Failed.");
                        break;
                    }
                    case 1: {
                        this.setIcon(this.okIcon);
                        this.setToolTipText("Success.");
                        break;
                    }
                    default: {
                        this.setIcon(this.unknownIcon);
                        this.setToolTipText("Unknown.");
                        break;
                    }
                }
            } else if (TestSetPanel.this.testCases != null) {
                int r = 1;
                for (int t = 0; t < TestSetPanel.this.testCases.length; ++t) {
                    if (((TestSetPanel)TestSetPanel.this).testCases[t].result == -1) {
                        r = -1;
                    }
                    if (((TestSetPanel)TestSetPanel.this).testCases[t].result != 0 || r <= 0) continue;
                    r = 0;
                }
                switch (r) {
                    case -1: {
                        this.setIcon(this.failedIcon);
                        this.setToolTipText("Failed.");
                        break;
                    }
                    case 1: {
                        this.setIcon(this.okIcon);
                        this.setToolTipText("Success.");
                        break;
                    }
                    default: {
                        this.setIcon(this.unknownIcon);
                        this.setToolTipText("Unknown.");
                        break;
                    }
                }
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private static class TestCase {
        public String label;
        public String description;
        public DefaultListModel console;
        public Anim animation;
        public int result;

        public TestCase(String label, String description) {
            this.label = label;
            this.description = description;
            this.console = new DefaultListModel();
            this.animation = null;
            this.result = 0;
        }

        public void reset() {
            this.console.clear();
            this.result = 0;
            this.animation = null;
        }

        public String toString() {
            return this.label;
        }
    }
}

