/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class StacktraceHighlightingCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1261623647064680003L;
    private Color error;
    private FileNameSource fs;

    public static int getErrorLineNr(String s) {
        try {
            if (s.indexOf(".java") >= 0) {
                int idx1 = s.indexOf(58);
                int idx2 = s.lastIndexOf(41);
                if (idx1 >= 0 && idx2 >= 0 && idx1 != idx2) {
                    String line = s.substring(idx1 + 1, idx2);
                    return Integer.parseInt(line);
                }
            }
            return -1;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static String getErrorFile(String s, FileNameSource fs) {
        String file;
        int idx1 = s.indexOf(".java");
        int idx2 = s.lastIndexOf(40);
        if (idx1 >= 0 && idx2 >= 0 && idx1 != idx2 && fs.fileNameExists(file = s.substring(idx2 + 1, idx1 + 5))) {
            return file;
        }
        return null;
    }

    public static boolean isErrorLine(String s, FileNameSource fs) {
        return StacktraceHighlightingCellRenderer.getErrorLineNr(s) >= 0 && StacktraceHighlightingCellRenderer.getErrorFile(s, fs) != null;
    }

    public StacktraceHighlightingCellRenderer(FileNameSource fs) {
        this(new Color(255, 220, 220), fs);
    }

    public StacktraceHighlightingCellRenderer(Color c, FileNameSource fs) {
        this.error = c;
        this.fs = fs;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = String.valueOf(value);
        JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        lbl.setBackground(StacktraceHighlightingCellRenderer.isErrorLine(s, this.fs) ? this.error : Color.WHITE);
        return lbl;
    }

    public static interface FileNameSource {
        public boolean fileNameExists(String var1);
    }
}

