/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client;

import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class JavaWordAction
extends TextAction {
    private String seps;
    private boolean select;
    private boolean forward;

    public JavaWordAction(String name, boolean select, boolean forward) {
        super(name);
        this.select = select;
        this.forward = forward;
        this.seps = " .,;=()\n'\"";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            try {
                int begOffs;
                int offs = target.getCaretPosition();
                int n = begOffs = this.forward ? this.getWordStart(target, offs) : this.getWordEnd(target, offs);
                if (this.select) {
                    target.moveCaretPosition(begOffs);
                } else {
                    target.setCaretPosition(begOffs);
                }
            }
            catch (BadLocationException bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        Document doc = c.getDocument();
        String text = doc.getText(0, doc.getLength());
        int wordPosition = offs;
        boolean isEnd = false;
        if (wordPosition < text.length() - 1) {
            do {
                char cc = text.charAt(++wordPosition);
                char pc = text.charAt(wordPosition - 1);
                boolean csc = this.isSeparatorChar(cc);
                boolean psc = this.isSeparatorChar(pc);
                boolean bl = isEnd = !csc && psc || csc && psc && cc != pc || csc && !psc;
            } while (wordPosition < text.length() - 1 && !isEnd);
        }
        return wordPosition;
    }

    public int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        Document doc = c.getDocument();
        String text = doc.getText(0, doc.getLength());
        int wordPosition = offs;
        boolean isEnd = false;
        while (wordPosition > 0 && !isEnd) {
            char pc = --wordPosition > 0 ? (char)text.charAt(wordPosition - 1) : (char)'\n';
            char cc = text.charAt(wordPosition);
            boolean csc = this.isSeparatorChar(pc);
            boolean psc = this.isSeparatorChar(cc);
            isEnd = !csc && psc || csc && psc && pc != cc || csc && !psc;
        }
        return wordPosition;
    }

    protected boolean isSeparatorChar(char c) {
        return this.seps.indexOf(c) >= 0;
    }
}

