/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.banner;

import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.moj.model.Clock;

public class BannerPanel
extends JPanel
implements Clock.Notification {
    private static final String[] validExtensions = new String[]{".jpg", ".gif", ".png"};
    private File[] srcFiles;
    private Image currentImage;
    private int currentFile;

    public BannerPanel(File imageDir) {
        this.srcFiles = imageDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = f.getName().toLowerCase();
                for (int t = 0; t < validExtensions.length; ++t) {
                    if (!name.endsWith(validExtensions[t])) continue;
                    return true;
                }
                return false;
            }
        });
        this.nextImage();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImage != null) {
            g.drawImage(this.currentImage, this.getWidth() / 2 - this.currentImage.getWidth(null) / 2, this.getHeight() / 2 - this.currentImage.getHeight(null) / 2, null);
        }
    }

    public void nextImage() {
        if (this.srcFiles == null || this.srcFiles.length == 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BannerPanel.this.currentImage = ImageIO.read(BannerPanel.this.srcFiles[BannerPanel.this.currentFile]);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BannerPanel.this.repaint();
                        }
                    });
                }
                catch (IOException ex) {
                    Logger.getLogger("BANNER").log(Level.WARNING, "Failed loading : " + BannerPanel.this.srcFiles[BannerPanel.this.currentFile] + " " + ex);
                }
            }
        }).start();
        ++this.currentFile;
        if (this.currentFile >= this.srcFiles.length) {
            this.currentFile = 0;
        }
    }

    @Override
    public void clockReset() {
    }

    @Override
    public void clockStarted() {
        this.nextImage();
    }

    @Override
    public void clockStopped() {
        this.nextImage();
    }

    @Override
    public void minutePassed(int remaining) {
        this.nextImage();
    }

    @Override
    public void clockFinished() {
    }
}

