/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.assignment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Tester;
import nl.moj.operation.Compile;
import nl.moj.operation.Save;
import nl.moj.operation.Submit;
import nl.moj.operation.Test;
import nl.moj.process.ProcessPool;
import nl.moj.security.DefaultSecurityDelegate;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.FileArrayClassLoader;

public class EclipseWorkspaceAssignment
implements Assignment {
    private static final String EXT_JAVA = ".java";
    private static final String EXT_CLASS = ".class";
    private static final String EXT_TXT = ".txt";
    private static final String EXT_IMG = ".jpg";
    private List<String> javaFiles = new ArrayList<String>();
    private List<String> textFiles = new ArrayList<String>();
    private String[] editableFiles;
    private String name;
    private Tester.SecurityDelegate delegate;
    private Operation[] theOps;
    private Map<String, File> fileNameTranslation = new HashMap<String, File>();
    private boolean isCombined;
    private byte[] iconImage;
    private byte[] sponsorImage;
    private String submitClass;
    private String testClass;
    private int submitClassTimeout = 20;
    private int testClassTimeout = 15;

    public EclipseWorkspaceAssignment(File projectRoot, ProcessPool pool, ApplicationBuilder parent) throws Exception {
        int t;
        boolean binExists;
        if (!projectRoot.isDirectory()) {
            throw new IOException("Need a workspace directory as starting point.");
        }
        File srcDir = new File(projectRoot, "src");
        File binDir = new File(projectRoot, "bin");
        boolean srcExists = srcDir.exists() && srcDir.isDirectory();
        boolean bl = binExists = binDir.exists() && binDir.isDirectory();
        if (srcExists ^ binExists) {
            throw new IOException("Either have both src and bin dirs or none.");
        }
        boolean bl2 = this.isCombined = srcExists && binExists;
        if (!this.isCombined) {
            srcDir = projectRoot;
            binDir = projectRoot;
        }
        this.name = projectRoot.getName();
        File[] java = srcDir.listFiles(new ExtensionFilter(EXT_JAVA));
        File[] txt = srcDir.listFiles(new ExtensionFilter(EXT_TXT));
        File[] bin = binDir.listFiles(new ExtensionFilter(EXT_CLASS));
        File[] images = binDir.listFiles(new ExtensionFilter(EXT_IMG));
        this.theOps = new Operation[4];
        this.theOps[0] = new Save(pool);
        this.theOps[1] = new Compile(pool);
        FileArrayClassLoader facl = new FileArrayClassLoader(bin, this.getClass().getClassLoader());
        for (int t2 = 0; t2 < bin.length; ++t2) {
            String className = bin[t2].getName();
            className = className.substring(0, className.lastIndexOf(46));
            Class<?> c = facl.loadClass(className);
            boolean removeSource = false;
            boolean removeBin = false;
            if (c.isInterface()) {
                // empty if block
            }
            if (Tester.Testable.class.isAssignableFrom(c)) {
                this.submitClass = c.getName();
                this.testClass = c.getName();
                this.theOps[2] = new Test((Assignment)this, pool, bin);
                this.theOps[3] = new Submit((Assignment)this, pool, bin);
                removeSource = true;
            }
            if (Tester.SecurityDelegate.class.isAssignableFrom(c)) {
                ApplicationBuilder ab = new ApplicationBuilder(parent);
                ab.build(new Class[]{c});
                this.delegate = (Tester.SecurityDelegate)ab.get(Tester.SecurityDelegate.class);
                if (this.delegate == null) {
                    throw new NullPointerException("Error getting '" + c.getName() + "' as Tester.SecurityDelegate");
                }
                removeSource = true;
            }
            if (removeBin) {
                bin[t2] = null;
            }
            if (!removeSource) continue;
            this.remove(java, c);
        }
        this.registerAssignmentWithSecurityManager();
        ArrayList<String> editable = new ArrayList<String>();
        for (t = 0; t < java.length; ++t) {
            if (java[t] == null) continue;
            this.fileNameTranslation.put(java[t].getName(), java[t]);
            this.javaFiles.add(java[t].getName());
            if (!java[t].getName().endsWith("Impl.java")) continue;
            editable.add(java[t].getName());
        }
        this.editableFiles = editable.toArray(new String[editable.size()]);
        for (t = 0; t < txt.length; ++t) {
            if (txt[t] == null) continue;
            this.fileNameTranslation.put(txt[t].getName(), txt[t]);
            this.textFiles.add(txt[t].getName());
        }
        if (this.theOps[2] == null) {
            throw new NullPointerException("Missing Tester.Testable implementation.");
        }
        if (this.delegate == null) {
            this.delegate = new DefaultSecurityDelegate();
        }
        for (t = 0; t < images.length; ++t) {
            if (images[t].getName().startsWith("sponsor-")) {
                if (this.sponsorImage != null) {
                    throw new IOException("Multiple sponsor images.");
                }
                this.sponsorImage = Tool.readBinary(new FileInputStream(images[t]), (int)images[t].length());
            }
            if (!images[t].getName().startsWith("icon-")) continue;
            if (this.sponsorImage != null) {
                throw new IOException("Multiple assignment icon images.");
            }
            this.iconImage = Tool.readBinary(new FileInputStream(images[t]), (int)images[t].length());
        }
    }

    protected void registerAssignmentWithSecurityManager() {
        SandboxSecurityManager ssm = (SandboxSecurityManager)System.getSecurityManager();
        ssm.registerAssignment(this);
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    protected void remove(File[] f, Class c) {
        String javaName = c.getName() + EXT_JAVA;
        for (int t = 0; t < f.length; ++t) {
            if (f[t] == null || !f[t].getName().equals(javaName)) continue;
            f[t] = null;
        }
    }

    @Override
    public InputStream getAssignmentFileData(String name) throws IOException {
        File f = this.fileNameTranslation.get(name);
        if (f == null) {
            throw new IOException("'" + name + "' does not exist.");
        }
        return new FileInputStream(f);
    }

    @Override
    public String[] getDescriptionFileNames() {
        return this.textFiles.toArray(new String[this.textFiles.size()]);
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return this.javaFiles.toArray(new String[this.javaFiles.size()]);
    }

    @Override
    public Operation[] getOperations() {
        return (Operation[])Tool.copy(this.theOps);
    }

    @Override
    public Tester.SecurityDelegate getSecurityDelegate() {
        return this.delegate;
    }

    @Override
    public String[] getEditableFileNames() {
        return (String[])Tool.copy(this.editableFiles);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDescriptionRenderedInMonospaceFont() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "Eclipse Workspace";
    }

    @Override
    public byte[] getIcon() {
        return this.iconImage;
    }

    @Override
    public byte[] getSponsorImage() {
        return this.sponsorImage;
    }

    @Override
    public String getSubmitClass() {
        return this.submitClass;
    }

    @Override
    public int getSubmitClassTimeout() {
        return this.submitClassTimeout;
    }

    @Override
    public String getTestClass() {
        return this.testClass;
    }

    @Override
    public int getTestClassTimeout() {
        return this.testClassTimeout;
    }

    @Override
    public int getDuration() {
        return 30;
    }

    private static class ExtensionFilter
    implements FileFilter {
        public String ext;

        public ExtensionFilter(String ext) {
            this.ext = ext.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return false;
            }
            return pathname.getName().toLowerCase().endsWith(this.ext);
        }
    }
}

