/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.assignment;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Tester;
import nl.moj.security.DefaultSecurityDelegate;
import nl.moj.security.SandboxSecurityManager;

public abstract class AbstractAssignment
implements Assignment {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_TXT = ".txt";
    public static final String EXT_MF = ".mf";
    public static final String EXT_GIF = ".gif";
    public static final String EXT_PNG = ".png";
    public static final String EXT_JPG = ".jpg";
    public static final String EXT_SOLUTION = ".solution";
    protected List<String> javaFiles = new ArrayList<String>();
    protected List<String> textFiles = new ArrayList<String>();
    protected String[] editableFiles;
    protected boolean textFileIsMonospaced;
    protected String name;
    protected String author;
    protected String assignmentIconName;
    protected String sponsorIconName;
    protected byte[] assignmentIconData;
    protected byte[] sponsorImageData;
    protected Tester.SecurityDelegate delegate;
    protected Operation[] theOps;
    protected String displayName;
    protected String authorURL;
    protected String catagory;
    protected String assignmentHint;
    protected int quality;
    protected int fun;
    protected int difficulty;
    protected String testClass;
    protected String submitClass;
    protected int testClassTimeout;
    protected int submitClassTimeout;
    protected int duration;

    protected abstract Enumeration getResources();

    protected abstract Resource getResource(String var1);

    protected abstract InputStream getInputStream(Resource var1) throws IOException;

    protected abstract ApplicationBuilder getApplicationBuilder();

    protected abstract ClassLoader createSecurityDelegateClassLoader();

    protected abstract Operation[] createOperations() throws Exception;

    protected void parseManifest(Manifest mf) throws Exception {
        Resource ze;
        Attributes a = mf.getMainAttributes();
        if (a == null) {
            throw new IOException("Missing MainAttributes in Manifest File.");
        }
        String val = a.getValue("Editable");
        if (val == null) {
            throw new IOException("'Editable' entry in MainAttributes is NULL - missing CRLF at the end ?");
        }
        this.editableFiles = Tool.cut(val, " ");
        String monospaced = a.getValue("Monospaced");
        this.textFileIsMonospaced = "TRUE".equalsIgnoreCase(monospaced);
        String securityDelegate = a.getValue("SecurityDelegate");
        if (securityDelegate != null) {
            ClassLoader cl = this.createSecurityDelegateClassLoader();
            ApplicationBuilder ab = new ApplicationBuilder(this.getApplicationBuilder());
            ab.register(Manifest.class, mf);
            ab.build(new Class[]{cl.loadClass(securityDelegate)});
            this.delegate = (Tester.SecurityDelegate)ab.get(Tester.SecurityDelegate.class);
            if (this.delegate == null) {
                throw new NullPointerException("Error getting '" + securityDelegate + "' as Tester.SecurityDelegate");
            }
        } else {
            this.delegate = new DefaultSecurityDelegate();
        }
        this.registerAssignmentWithSecurityManager();
        Enumeration entries = this.getResources();
        while (entries.hasMoreElements()) {
            Resource e = (Resource)entries.nextElement();
            String name = e.getName();
            if (name.endsWith(EXT_JAVA)) {
                this.javaFiles.add(name);
                continue;
            }
            if (name.endsWith(EXT_TXT)) {
                this.textFiles.add(name);
                continue;
            }
            if (name.endsWith(EXT_CLASS) || name.toLowerCase().endsWith(EXT_PNG) || name.toLowerCase().endsWith(EXT_JPG) || name.toLowerCase().endsWith(EXT_GIF) || name.toLowerCase().endsWith(EXT_MF) || name.endsWith("/") || name.endsWith(EXT_SOLUTION)) continue;
            throw new IOException("Unexpected file : " + name);
        }
        for (int t = 0; t < this.editableFiles.length; ++t) {
            if (this.javaFiles.contains(this.editableFiles[t])) continue;
            throw new NullPointerException("Editable File '" + this.editableFiles[t] + "' is not present as a Java File!");
        }
        this.testClass = a.getValue("TestClass");
        this.submitClass = a.getValue("SubmitClass");
        this.testClassTimeout = Integer.parseInt(a.getValue("TestClassTimeout") == null ? "-1" : a.getValue("TestClassTimeout"));
        this.submitClassTimeout = Integer.parseInt(a.getValue("SubmitClassTimeout") == null ? "-1" : a.getValue("SubmitClassTimeout"));
        if (this.testClass == null) {
            throw new IOException("Missing 'TestClass' entry.");
        }
        if (this.submitClass == null) {
            throw new IOException("Missing 'SubmitClass' entry.");
        }
        if (this.testClassTimeout == -1) {
            throw new IOException("Missing or invalid 'TestClassTimeout' entry.");
        }
        if (this.submitClassTimeout == -1) {
            throw new IOException("Missing or invalid 'SubmitClassTimeout' entry.");
        }
        this.theOps = this.createOperations();
        this.author = a.getValue("Author");
        String tmp = a.getValue("SponsorImage");
        if (tmp != null) {
            ze = this.getResource(tmp);
            if (ze == null) {
                throw new NullPointerException("Resource not found for " + tmp);
            }
            this.sponsorIconName = tmp;
            this.sponsorImageData = Tool.readBinary(this.getInputStream(ze), (int)ze.getSize());
        }
        if ((tmp = a.getValue("Icon")) != null) {
            ze = this.getResource(tmp);
            if (ze == null) {
                throw new NullPointerException("ZipEntry not found for " + tmp);
            }
            this.assignmentIconName = tmp;
            this.assignmentIconData = Tool.readBinary(this.getInputStream(ze), (int)ze.getSize());
        }
        this.displayName = a.getValue("DisplayName");
        this.authorURL = a.getValue("AuthorURL");
        this.catagory = a.getValue("Catagory");
        this.assignmentHint = a.getValue("Hint");
        this.quality = Integer.parseInt(a.getValue("Quality") == null ? "3" : a.getValue("Quality"));
        this.fun = Integer.parseInt(a.getValue("Fun") == null ? "3" : a.getValue("Fun"));
        this.difficulty = Integer.parseInt(a.getValue("Difficulty") == null ? "3" : a.getValue("Difficulty"));
        String dur = a.getValue("Duration");
        if (dur == null) {
            dur = "30";
        }
        this.duration = Integer.parseInt(dur);
    }

    protected void registerAssignmentWithSecurityManager() {
        SandboxSecurityManager ssm = (SandboxSecurityManager)System.getSecurityManager();
        ssm.registerAssignment(this);
    }

    @Override
    public String getTestClass() {
        return this.testClass;
    }

    @Override
    public String getSubmitClass() {
        return this.submitClass;
    }

    @Override
    public int getTestClassTimeout() {
        return this.submitClassTimeout;
    }

    @Override
    public int getSubmitClassTimeout() {
        return this.submitClassTimeout;
    }

    @Override
    public String[] getDescriptionFileNames() {
        return this.textFiles.toArray(new String[this.textFiles.size()]);
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return this.javaFiles.toArray(new String[this.javaFiles.size()]);
    }

    @Override
    public Operation[] getOperations() {
        return (Operation[])Tool.copy(this.theOps);
    }

    @Override
    public Tester.SecurityDelegate getSecurityDelegate() {
        return this.delegate;
    }

    @Override
    public String[] getEditableFileNames() {
        return (String[])Tool.copy(this.editableFiles);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    @Override
    public boolean isDescriptionRenderedInMonospaceFont() {
        return this.textFileIsMonospaced;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public String getIconName() {
        return this.assignmentIconName;
    }

    public String getSponsorIconName() {
        return this.sponsorIconName;
    }

    @Override
    public byte[] getIcon() {
        return this.assignmentIconData;
    }

    @Override
    public byte[] getSponsorImage() {
        return this.sponsorImageData;
    }

    public String getAuthorURL() {
        return this.authorURL;
    }

    public String getCatagory() {
        return this.catagory;
    }

    public String getHint() {
        return this.assignmentHint;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getFun() {
        return this.fun;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public static interface Resource {
        public String getName();

        public long getSize();
    }
}

