/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Tool {
    public static String read(File f, boolean trim) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        return Tool.read(r, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File f, String text) throws IOException {
        FileWriter out = new FileWriter(f);
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(BufferedReader r, boolean trim) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            String s = r.readLine();
            while (s != null) {
                if (trim) {
                    sb.append(s.trim());
                } else {
                    sb.append(s);
                }
                sb.append("\n");
                s = r.readLine();
            }
        }
        finally {
            r.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinary(InputStream f, int length) throws IOException {
        BufferedInputStream in = new BufferedInputStream(f);
        byte[] myData = new byte[length];
        try {
            int c;
            int r = 0;
            do {
                if ((c = in.read(myData, r, myData.length - r)) >= 0) continue;
                throw new IOException("Missing data.");
            } while ((r += c) < myData.length);
        }
        finally {
            in.close();
        }
        return myData;
    }

    public static String[] cut(String s, String sep) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, sep);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    public static String[] cutForEach(String s, String sep) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < s.length(); ++t) {
            char c = s.charAt(t);
            if (sep.indexOf(c) >= 0) {
                l.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(c);
        }
        l.add(sb.toString());
        return l.toArray(new String[l.size()]);
    }

    public static String arrayToString(Object[] o) {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < o.length; ++t) {
            if (t > 0) {
                sb.append(',');
            }
            sb.append(o[t].toString());
        }
        return sb.toString();
    }

    public static String replace(String src, String from, String to) {
        int idx = src.indexOf(from);
        if (idx < 0) {
            return src;
        }
        StringBuffer sb = new StringBuffer();
        while (idx >= 0) {
            sb.append(src.substring(0, idx));
            sb.append(to);
            src = src.substring(idx + from.length());
            idx = src.indexOf(from);
        }
        sb.append(src);
        return sb.toString();
    }

    public static int count(String src, String chars) {
        int cnt = 0;
        for (int t = 0; t < src.length(); ++t) {
            if (chars.indexOf(src.charAt(t)) < 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public static String concat(String[] s, String sep) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < s.length; ++t) {
            if (t != 0) {
                sb.append(sep);
            }
            sb.append(s[t]);
        }
        return sb.toString();
    }

    public static String[] arrayify(String message) {
        ArrayList<String> l = new ArrayList<String>();
        int i = -1;
        while ((i = message.indexOf("\n")) >= 0) {
            String sub = message.substring(0, i);
            if (sub.endsWith("\r")) {
                sub = sub.substring(0, i - 1);
            }
            l.add(sub);
            if (!(message = message.substring(i + 1)).startsWith("\r")) continue;
            message = message.substring(1);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String[] parseArgs(String[] src) {
        ArrayList<CharSequence> myResults = new ArrayList<CharSequence>();
        boolean inQuote = false;
        StringBuffer concat = new StringBuffer();
        for (int t = 0; t < src.length; ++t) {
            if (src[t].startsWith("\"")) {
                inQuote = true;
                concat.delete(0, concat.length());
                concat.append(src[t].substring(1));
                continue;
            }
            if (inQuote) {
                if (src[t].endsWith("\"")) {
                    inQuote = false;
                    concat.append(' ');
                    concat.append(src[t].substring(0, src[t].length() - 1));
                    myResults.add(concat);
                    continue;
                }
                concat.append(' ');
                concat.append(src[t]);
                continue;
            }
            myResults.add(src[t]);
        }
        if (inQuote) {
            throw new RuntimeException("Missing closing quote.");
        }
        return myResults.toArray(new String[myResults.size()]);
    }

    public static String[] parseStringWithQuotes(String s) {
        ArrayList<String> myResults = new ArrayList<String>();
        boolean inQuote = false;
        char what = '\u0000';
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < s.length(); ++t) {
            char c = s.charAt(t);
            if (!inQuote) {
                if (c == '\"') {
                    if (sb.length() > 0) {
                        myResults.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append(c);
                    inQuote = true;
                    what = '\"';
                    continue;
                }
                if (c == '\'') {
                    if (sb.length() > 0) {
                        myResults.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append(c);
                    inQuote = true;
                    what = '\'';
                    continue;
                }
                if (c == ' ') {
                    myResults.add(sb.toString());
                    sb.delete(0, sb.length());
                    sb.append(c);
                    myResults.add(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                if (c == '(' || c == ')' || c == '{' || c == '}') {
                    if (sb.length() > 0) {
                        myResults.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append(c);
                    myResults.add(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == what) {
                sb.append(c);
                inQuote = false;
                what = '\u0000';
                if (sb.length() <= 0) continue;
                myResults.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(c);
        }
        if (inQuote) {
            throw new RuntimeException("Missing closing quote.");
        }
        if (sb.length() > 0) {
            myResults.add(sb.toString());
            sb.delete(0, sb.length());
        }
        return myResults.toArray(new String[myResults.size()]);
    }

    public static String decodeEscape(String s, char escapeID, String srcChars, String targetChars) {
        if (srcChars.length() != targetChars.length()) {
            throw new RuntimeException("srcChars does match targetChars length.");
        }
        StringBuffer sb = new StringBuffer();
        boolean inEscape = false;
        for (int t = 0; t < s.length(); ++t) {
            char c = s.charAt(t);
            if (c == escapeID && !inEscape) {
                inEscape = true;
                continue;
            }
            if (!inEscape) {
                sb.append(c);
                continue;
            }
            int i = srcChars.indexOf(c);
            if (i < 0) {
                throw new RuntimeException("Illegal Escape sequence char " + c + " in String '" + s + "' at position " + t);
            }
            sb.append(targetChars.charAt(i));
            inEscape = false;
        }
        return sb.toString();
    }

    public static String encodeEscape(String s, char escapeID, String srcChars, String targetChars) {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < s.length(); ++t) {
            char c = s.charAt(t);
            int i = srcChars.indexOf(c);
            if (i >= 0) {
                sb.append(escapeID);
                sb.append(targetChars.charAt(i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String dequote(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static Object[] copy(Object[] src) {
        if (src == null) {
            return null;
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length);
        for (int t = 0; t < src.length; ++t) {
            dst[t] = src[t];
        }
        return dst;
    }
}

