/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.sound;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.Mixer;

public class SoundPlayer {
    private Mixer myMixer;
    private Timer soundStopper;
    private long closeAfterStopDelay;

    public SoundPlayer() throws SoundPlayerException {
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        if (mi.length == 0) {
            throw new SoundPlayerException("No Audio Hardware available.");
        }
        this.myMixer = AudioSystem.getMixer(mi[0]);
    }

    public SoundPlayer(long closeAfterStopdelay) throws SoundPlayerException {
        this();
        this.soundStopper = new Timer(true);
        this.closeAfterStopDelay = closeAfterStopdelay;
    }

    public void play(File aFile) throws SoundPlayerException {
        if (aFile == null) {
            throw new NullPointerException("The file is NULL.");
        }
        if (!aFile.exists()) {
            throw new SoundPlayerException("File " + aFile + " does not exist.");
        }
        try {
            AudioFormat format = AudioSystem.getAudioFileFormat(aFile).getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            final Clip line = (Clip)this.myMixer.getLine(info);
            line.open(AudioSystem.getAudioInputStream(aFile));
            line.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent le) {
                    if (le.getType().equals(LineEvent.Type.STOP)) {
                        if (SoundPlayer.this.soundStopper != null) {
                            SoundPlayer.this.soundStopper.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    line.close();
                                }
                            }, SoundPlayer.this.closeAfterStopDelay);
                        } else {
                            line.close();
                        }
                    }
                }
            });
            line.start();
        }
        catch (Exception e) {
            throw new SoundPlayerException("Unable to play sample : " + e);
        }
    }

    public static void main(String[] args) throws Throwable {
        new SoundPlayer(200L).play(new File("D:\\music\\wav\\ss2\\shodan\\shodan asterisk.wav"));
    }

    public class SoundPlayerException
    extends Exception {
        public SoundPlayerException(String s) {
            super(s);
        }
    }
}

