/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.net.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nl.ctrlaltdev.net.server.Log;
import nl.ctrlaltdev.net.server.SocketHandlerFactory;

public class SimpleSocketServer
implements Runnable,
Log {
    private ServerSocket myServerSocket;
    private boolean shouldStop;
    private boolean isRunning;
    private Log myLog;
    private SocketHandlerFactory myFactory;
    private ThreadGroup mySocketThreadGroup;
    private boolean testMode;
    private int noActivitiyCnt;

    public SimpleSocketServer(int port, Log l, SocketHandlerFactory hf, InetAddress addr) throws IOException {
        this.myServerSocket = new ServerSocket(port, 50, addr);
        this.myServerSocket.setSoTimeout(5000);
        if (l == null) {
            l = this;
        }
        this.myLog = l;
        this.myFactory = hf;
        this.noActivitiyCnt = 0;
    }

    public SimpleSocketServer(int port, Log l, SocketHandlerFactory hf) throws IOException {
        this.myServerSocket = new ServerSocket(port);
        this.myServerSocket.setSoTimeout(5000);
        if (l == null) {
            l = this;
        }
        this.myLog = l;
        this.myFactory = hf;
        this.noActivitiyCnt = 0;
    }

    public SimpleSocketServer(int port, Log l, SocketHandlerFactory hf, boolean testMode) throws IOException {
        this(port, l, hf);
        this.testMode = testMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.myLog.info("Running on " + this.myServerSocket.getLocalSocketAddress());
        this.shouldStop = false;
        this.isRunning = true;
        this.mySocketThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "ServerThreadGroup");
        try {
            while (!this.shouldStop) {
                try {
                    Socket s = this.myServerSocket.accept();
                    this.noActivitiyCnt = 0;
                    this.myLog.info("Accepted connection from " + s.getInetAddress() + ":" + s.getPort());
                    Runnable r = this.myFactory.createHandler(s, this.myLog);
                    new Thread(this.mySocketThreadGroup, r).start();
                }
                catch (SocketTimeoutException ex) {
                    ++this.noActivitiyCnt;
                    if (!this.testMode || this.noActivitiyCnt <= 10) continue;
                    this.myLog.info("Terminated.");
                    System.exit(0);
                }
                catch (IOException e) {
                    this.myLog.error("Failed to accept a socket : " + e);
                }
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.shouldStop = true;
    }

    @Override
    public void debug(Object o) {
        System.out.println(o);
    }

    @Override
    public void error(Object o) {
        System.out.println(o);
    }

    @Override
    public void info(Object o) {
        System.out.println(o);
    }

    @Override
    public void warn(Object o) {
        System.out.println(o);
    }
}

