/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class OutputRedirector {
    private PrintStreamWrapper stdOut;
    private PrintStreamWrapper stdErr;
    private static OutputRedirector red;

    private OutputRedirector() {
        if (this.isApplied()) {
            throw new RuntimeException("Output Redirection is already applied.");
        }
        this.apply();
    }

    private boolean isApplied() {
        return System.out instanceof PrintStreamWrapper && System.err instanceof PrintStreamWrapper;
    }

    private void apply() {
        this.stdOut = new PrintStreamWrapper(System.out);
        this.stdErr = new PrintStreamWrapper(System.err);
        System.setOut(this.stdOut);
        System.setErr(this.stdErr);
    }

    public void setContext(String ctx) {
        this.stdErr.setContext(ctx);
        this.stdOut.setContext(ctx);
    }

    public void redirect(Thread t, Target rdr) {
        this.stdOut.addThread(t, rdr);
        this.stdErr.addThread(t, rdr);
    }

    public void redirectToSame(Thread newThread, Thread alreadyRedirectedThread) {
        this.stdOut.addThread(newThread, alreadyRedirectedThread);
        this.stdErr.addThread(newThread, alreadyRedirectedThread);
    }

    public void cancel(Thread t) {
        this.stdOut.removeThread(t);
        this.stdErr.removeThread(t);
    }

    public void removeTerminated() {
        this.stdErr.removeTerminated();
        this.stdOut.removeTerminated();
    }

    public static synchronized OutputRedirector getSingleton() {
        if (red == null) {
            red = new OutputRedirector();
        }
        if (!red.isApplied()) {
            red.apply();
        }
        return red;
    }

    public static class PrintStreamWrapper
    extends PrintStream {
        private PrintStream trg;
        private Map<Thread, RedirectorPrintStream> myThreads = new HashMap<Thread, RedirectorPrintStream>();

        public PrintStreamWrapper(PrintStream target) {
            super(new DummyOutputStream());
            if (target == null) {
                throw new NullPointerException("Need Target PrintStream.");
            }
            this.trg = target;
        }

        public void setContext(String ctx) {
            PrintStream prt = this.redirect();
            if (prt instanceof RedirectorPrintStream) {
                ((RedirectorPrintStream)prt).setContext(ctx);
            }
        }

        @Override
        public boolean checkError() {
            return this.trg.checkError();
        }

        @Override
        public void close() {
            this.trg.close();
        }

        @Override
        public void flush() {
            this.trg.flush();
        }

        @Override
        public void print(boolean b) {
            this.redirect().print(b);
        }

        @Override
        public void print(char b) {
            this.redirect().print(b);
        }

        @Override
        public void print(char[] b) {
            this.redirect().print(b);
        }

        @Override
        public void print(double b) {
            this.redirect().print(b);
        }

        @Override
        public void print(float b) {
            this.redirect().print(b);
        }

        @Override
        public void print(int b) {
            this.redirect().print(b);
        }

        @Override
        public void print(long b) {
            this.redirect().print(b);
        }

        @Override
        public void print(Object b) {
            this.redirect().print(b);
        }

        @Override
        public void print(String b) {
            this.redirect().print(b);
        }

        @Override
        public void println() {
            this.redirect().println();
        }

        @Override
        public void println(boolean x) {
            this.redirect().println(x);
        }

        @Override
        public void println(char x) {
            this.redirect().println(x);
        }

        @Override
        public void println(char[] x) {
            this.redirect().println(x);
        }

        @Override
        public void println(double x) {
            this.redirect().println(x);
        }

        @Override
        public void println(float x) {
            this.redirect().println(x);
        }

        @Override
        public void println(int x) {
            this.redirect().println(x);
        }

        @Override
        public void println(long x) {
            this.redirect().println(x);
        }

        @Override
        public void println(Object x) {
            this.redirect().println(x);
        }

        @Override
        public void println(String x) {
            this.redirect().println(x);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.trg.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.trg.write(buf, off, len);
        }

        @Override
        public void write(int b) {
            this.trg.write(b);
        }

        public synchronized void addThread(Thread t, Target redir) {
            this.myThreads.put(t, new RedirectorPrintStream(redir));
        }

        public synchronized void addThread(Thread newThread, Thread existing) {
            RedirectorPrintStream rdr = this.myThreads.get(existing);
            if (rdr == null) {
                return;
            }
            this.myThreads.put(newThread, rdr.copy());
        }

        public synchronized void removeThread(Thread t) {
            this.myThreads.remove(t);
        }

        protected synchronized PrintStream redirect() {
            RedirectorPrintStream rdr = this.myThreads.get(Thread.currentThread());
            if (rdr == null) {
                return this.trg;
            }
            return rdr;
        }

        public synchronized void removeTerminated() {
            Thread[] tr = this.myThreads.keySet().toArray(new Thread[this.myThreads.size()]);
            for (int t = 0; t < tr.length; ++t) {
                if (tr[t].isAlive()) continue;
                this.myThreads.remove(tr[t]);
            }
        }
    }

    public static class RedirectorPrintStream
    extends PrintStream {
        private Target myRDR;
        private String context;

        public RedirectorPrintStream(Target rdr) {
            super(new DummyOutputStream());
            this.myRDR = new SynchronizedTarget(rdr);
        }

        public RedirectorPrintStream copy() {
            RedirectorPrintStream r = new RedirectorPrintStream(null);
            r.myRDR = this.myRDR;
            r.setContext(this.getContext());
            return r;
        }

        public void setContext(String ctx) {
            this.context = ctx;
        }

        public String getContext() {
            return this.context;
        }

        @Override
        public void print(boolean b) {
            this.myRDR.append(this.context, b ? "true" : "false");
        }

        @Override
        public void print(char b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(char[] b) {
            this.myRDR.append(this.context, new String(b));
        }

        @Override
        public void print(double b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(float b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(int b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(long b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(Object b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(String b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void println() {
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(boolean x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(char x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(char[] x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(double x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(float x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(int x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(long x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(Object x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(String x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }
    }

    public static class RedirectorPrintWriter
    extends PrintWriter {
        private Target myRDR;
        private String context;

        public RedirectorPrintWriter(Target rdr) {
            super(new DummyOutputStream());
            this.myRDR = rdr;
        }

        public void setContext(String ctx) {
            this.context = ctx;
        }

        @Override
        public void print(boolean b) {
            this.myRDR.append(this.context, b ? "true" : "false");
        }

        @Override
        public void print(char b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(char[] b) {
            this.myRDR.append(this.context, new String(b));
        }

        @Override
        public void print(double b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(float b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(int b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(long b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(Object b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void print(String b) {
            this.myRDR.append(this.context, String.valueOf(b));
        }

        @Override
        public void println() {
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(boolean x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(char x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(char[] x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(double x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(float x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(int x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(long x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(Object x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void println(String x) {
            this.myRDR.append(this.context, String.valueOf(x));
            this.myRDR.append(this.context, "\n");
        }

        @Override
        public void write(char[] buf) {
            this.myRDR.append(this.context, new String(buf));
        }

        @Override
        public void write(String s) {
            this.myRDR.append(this.context, s);
        }

        @Override
        public void write(int c) {
            this.myRDR.append(this.context, String.valueOf((char)c));
        }

        @Override
        public void write(String s, int off, int len) {
            this.myRDR.append(this.context, s.substring(off, off + len));
        }

        @Override
        public void write(char[] s, int off, int len) {
            this.myRDR.append(this.context, new String(s).substring(off, off + len));
        }
    }

    public static class DummyOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    public static class SynchronizedTarget
    implements Target {
        private Target t;

        public SynchronizedTarget(Target t) {
            this.t = t;
        }

        @Override
        public synchronized void append(String context, String s) {
            this.t.append(context, s);
        }
    }

    public static interface Target {
        public void append(String var1, String var2);
    }
}

