package nl.moj.test.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.gamerules.CompetitionGameRules;
import nl.moj.model.Assignment;
import nl.moj.model.GameRules;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.round.TeamImpl;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.TesterImpl;
import nl.moj.test.junit.dummy.DummyAssignment;
import nl.moj.test.junit.dummy.DummyClock;
import nl.moj.test.junit.dummy.DummyState;
import nl.moj.test.junit.dummy.DummyWorkspace;

import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * Tests the Tester. 
 * Note : classloading and security is not checked in this test. 
 */

public class TesterTest extends TestCase {
	
	static {
		Logger root=Logger.getLogger("");
		Handler[] h=root.getHandlers();
		for (int t=0;t<h.length;t++) root.removeHandler(h[t]);
		//
		ThreadGroup tmp=new ThreadGroup("evil");
		SandboxSecurityManager ssm=new SandboxSecurityManager(tmp);	
		System.setSecurityManager(ssm);
		OutputRedirector.getSingleton();
		//
		root.addHandler(new ConsoleHandler());
		//
	}

	public static class DummyTestCase implements Tester.Testable {
		//
		private static final String[] testNames=new String[] { "Name1","Name2","Name3","Timeout" };
		private static final String[] testDescriptions=new String[] {"D1","D2","D3","X1" };		
		//
        public int getTestCount() {
            return testNames.length;
        }
		public String getTestDescription(int nr) {
		    return testDescriptions[nr];
		}
		public String getTestName(int nr) {
			return testNames[nr];
		}
		public boolean[] performTest() throws Throwable {
			boolean[] r=new boolean[testNames.length];
			for (int t=0;t<testNames.length;t++) {
				r[t]=performTest(t);
			}
			return r;
		}
		public boolean performTest(int nr) throws Throwable {
			switch (nr) {
				case 0 : return true;
				case 1 : return false;
				case 2 : throw new NullPointerException("BOEM");
				case 3 : Thread.sleep(10000);
						 return true;
				default: return false;
			}			
		}
	}

	static {
		// Disable Logging.
		Logger.getLogger("").setLevel(Level.OFF);
	}

	private static File dummyFile;	
	/** creates a dummy jar file */
	private static File getJarFile() throws IOException{
		if (dummyFile==null){
			File f=File.createTempFile("test","jar");
			ZipOutputStream zout=new ZipOutputStream(new FileOutputStream(f));
			try {
				ZipEntry current=new ZipEntry("readme.txt");
				try {			
					zout.putNextEntry(current);
					zout.write("HalloWereld".getBytes());
				} finally {
					zout.closeEntry();
				}
			} finally {
				zout.close();
			}
			dummyFile=f;
		}
		return dummyFile; 
	}
	
	private TesterImpl myTester;
	private Team myTeam;
	private Workspace.Internal myWorkSpace;
	private Assignment myAssignment;

	public TesterTest(String s) { 
		super(s);
	}
	
    protected void setUp() throws Exception {
		myAssignment=new DummyAssignment();
    	GameRules myGameRules=new CompetitionGameRules(new DummyClock());
    	TeamImpl ti=new TeamImpl("a","a","a",myAssignment,myGameRules,new DummyState(),null);
    	myWorkSpace=new DummyWorkspace(ti);
    	ti.setWorkspace(myWorkSpace);
    	myTeam=ti;
		myTester=new TesterImpl(myAssignment,
			"nl.moj.test.junit.TesterTest$DummyTestCase",
			getJarFile(),
			2
		);
    }
    
    public void testTesterProperties() {
		//
		Assert.assertEquals("TestNameCount",myTester.getTestNames().length,DummyTestCase.testNames.length);
		Assert.assertEquals("TestDescriptionCount",myTester.getTestDescriptions().length,DummyTestCase.testDescriptions.length);
		// 
		for (int t=0;t<DummyTestCase.testNames.length;t++) {
			Assert.assertEquals(myTester.getTestNames()[t],DummyTestCase.testNames[t]);
		}
		//
		for (int t=0;t<DummyTestCase.testDescriptions.length;t++) {
			Assert.assertEquals(myTester.getTestDescriptions()[t],DummyTestCase.testDescriptions[t]);
		}
		//		
    }
    
    public void testSingleTest() throws Exception {
    	//
    	Tester.TestResult tr=myTester.performTest(myWorkSpace,0);    	
		int[] r=tr.getResults();
		Assert.assertTrue(tr.isOk());
		Assert.assertEquals(Tester.TestResult.PASS,r[0]);
		Assert.assertEquals(0,r[1]);
		Assert.assertEquals(0,r[2]);
		//
		tr=myTester.performTest(myWorkSpace,1);
		r=tr.getResults();
		Assert.assertTrue(tr.isFaulty());
		Assert.assertEquals(0,r[0]);
		Assert.assertEquals(Tester.TestResult.FAIL,r[1]);
		Assert.assertEquals(0,r[2]);
		//
		// This one throws an exception, so
		// the array will not be filled.
		//
		tr=myTester.performTest(myWorkSpace,2);
		r=tr.getResults();
		Assert.assertTrue(tr.isFaulty());
		Assert.assertEquals(1,r.length);		
		//
		// This one will timeout
		//
		tr=myTester.performTest(myWorkSpace,3);
		r=tr.getResults();
		Assert.assertTrue(tr.isFaulty());
		Assert.assertEquals(1,r.length);		
		//
		dumpTeam(myTeam);
		//
    }
    
    public void testAllTests() throws Exception {
		//
		Tester.TestResult tr=myTester.performTest(myWorkSpace);    	
		int[] r=tr.getResults();
		Assert.assertTrue(tr.isFaulty());
		Assert.assertEquals(1,r.length);		
		//
		dumpTeam(myTeam);
		//    
    }
    
    public void dumpTeam(Team myTeam) {
    	String[][] l=myTeam.getLines();
    	for (int t=0;t<l.length;t++) {
    		//System.out.println(l[t][1]);
    	}
    }


	public static void main(String[] args) {
		junit.textui.TestRunner.run(TesterTest.class);
	}	

}
