package nl.moj.test.junit;

import java.util.logging.Level;
import java.util.logging.Logger;

import nl.moj.gamerules.CompetitionGameRules;
import nl.moj.model.Assignment;
import nl.moj.model.GameRules;
import nl.moj.model.Team;
import nl.moj.round.TeamImpl;
import nl.moj.test.junit.dummy.DummyAssignment;
import nl.moj.test.junit.dummy.DummyClock;
import nl.moj.test.junit.dummy.DummyState;
import nl.moj.test.junit.dummy.DummyWorkspace;
import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * Tests the basic properties of TeamImpl and the login/logout behaviour.
 * A test over a complete round is done in the RoundTest.
 */
public class TeamTest extends TestCase {

	private static final String TEAMNAME="TestTeam";
	private static final String TEAMDISPLAYNAME="Test Team";
	private static final String PASSWORD="test";

	static {
		// Disable Logging.
		Logger.getLogger("").setLevel(Level.OFF);
	}

	private Team testTeam;
	private DummyState myState;
	private DummyWorkspace myWorkspace;
	private DummyClock myClock;
	private GameRules myGameRules;
	private Assignment myAssignment;
	
    public TeamTest(String arg0) {
        super(arg0);
    }
    protected void setUp() throws Exception {
    	myState=new DummyState();
    	myClock=new DummyClock();
    	myGameRules=new CompetitionGameRules(myClock);
    	myAssignment=new DummyAssignment();
		TeamImpl testTeamImpl=new TeamImpl(TEAMNAME,TEAMDISPLAYNAME,PASSWORD,myAssignment,myGameRules,myState,null);
    	myWorkspace=new DummyWorkspace(testTeamImpl);
		testTeamImpl.setWorkspace(myWorkspace);
        testTeam=testTeamImpl; 
    }
    
    public void testProperties() {
    	Assert.assertEquals("Name",TEAMNAME,testTeam.getName());
		Assert.assertEquals("DisplayName",TEAMDISPLAYNAME,testTeam.getDisplayName());
		Assert.assertFalse("Online(1)",testTeam.isOnline());
		Assert.assertTrue("Valid Password",testTeam.isValidPassword(PASSWORD));
		Assert.assertTrue("Online(2)",testTeam.isOnline());
		Assert.assertFalse("Valid Password",testTeam.isValidPassword(null));
		Assert.assertFalse("Online(3)",testTeam.isOnline());
		Assert.assertEquals(testTeam.getClock().getDuration(),myClock.getDuration());
		//
		for (int m=0;m<30;m++) {
			for (int s=0;s<60;s++) {
				myClock.setTime(m,s);
				Assert.assertEquals(testTeam.getClock().getSecondsRemaining(),myClock.getDuration()-myClock.getSecondsPassed());
				Assert.assertEquals(testTeam.getTheoreticalScore(),myClock.getDuration()-myClock.getSecondsPassed());
			}
		}
		//
    }

	public static void main(String[] args) {
		junit.textui.TestRunner.run(TeamTest.class);
	}

}
