package nl.moj.test.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.model.Assignment;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.junit.dummy.DummyAssignment;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

/**
 * Some tests for the SandboxSecurityManager
 * @author E.Hooijmeijer
 */

public class SandboxSecurityManagerTest extends TestCase {

	// Create the Evil Threadgroup - all threads in this group are potentially evil and must be checked !
	public static final ThreadGroup evil=new ThreadGroup("evil");
	
	private Assignment myAssignment;
	private SandboxSecurityManager ssm;
	private ThreadGroup assignmentThreadGroup;
	
	public void setUp() {
		myAssignment=new DummyAssignment();
		SimpleLogFormatter.clearLogConfig();
		ssm=new SandboxSecurityManager(evil);
		System.setSecurityManager(ssm);
		ssm.registerAssignment(myAssignment);
		assignmentThreadGroup=ssm.getEvilThreadGroup(myAssignment);
	}
	
	public void testSystemExit() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					System.exit(0);
				} catch (SecurityException ex) {
					// Good !
				}				
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	public void testSocket() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new Socket("127.0.0.1",8080);
					results.add(new AssertionFailedError("Created Socket"));
				} catch (IOException ex) {
					results.add(new AssertionFailedError("Socket creation failed with "+ex));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}

	public void testServerSocket() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new ServerSocket(8080);
					results.add(new AssertionFailedError("Created Socket"));
				} catch (IOException ex) {
					results.add(new AssertionFailedError("Socket creation failed with "+ex));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}

	public void testClassLoader() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new ClassLoader() {};
					results.add(new AssertionFailedError("ClassLoader Created"));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	
	public void testWrapperConversions() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					String.valueOf(Boolean.TRUE);
					String.valueOf(1024);
					String.valueOf(5.0);
					String.valueOf('c');
					//
					Integer.parseInt("1");
					Long.parseLong("1");
					Float.parseFloat("1.0");
					Double.parseDouble("1.0");
					//
					// Allowed : Good !
					//
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("Cant convert :"+ex.getMessage()));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}	

	public void testFileXS() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new File("c:/pindakaas.txt").delete();
					results.add(new AssertionFailedError("File Delete Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Delete Failed."));
				}
				//
				try {
					FileOutputStream out=new FileOutputStream(new File("c:/pindakaas.txt"));
					try {
						out.write(32);
					} finally {
						out.close();
					}
					results.add(new AssertionFailedError("File Write Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Write Failed."));
				}
				//
				try {
					FileInputStream in=new FileInputStream(new File("c:/pindakaas.txt"));
					try {
						in.read();
					} finally {
						in.close();
					}
					results.add(new AssertionFailedError("File Read Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Read Failed."));
				}
				//
				try {
					FileInputStream in=new FileInputStream(new File("c:/workspace/bin/pindakaas.txt"));
					try {
						in.read();
					} finally {
						in.close();
					}
					// Good
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("Must be allows to read from ./workspace/*/bin"));
				} catch (Exception ex) {
					// Good
				}				
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
		//
	}	

	
	
	
	
}
