package nl.moj.test.junit;

import nl.moj.scoreboard.scoringrules.MoJ2005ScoringRules;
import junit.framework.Assert;
import junit.framework.TestCase;

public class MoJ2005ScoringRulesTest extends TestCase {
	
	public void testLinear() throws Throwable {
		int[]    in =new int[]    { 1412,1211,800,600,500,400,300,200,100,87,24,12, 9 };
		double[] out=new double[] {   20,  18, 16, 14, 12, 10,  1,  1,  1, 1, 1, 1, 1 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}

	public void testNonLinear() throws Throwable {
		int[]    in =new int[]    { 10,90,20,80,30,70,40,60 };
		double[] out=new double[] {  1,20, 1,18,10,16,12,14 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}
	
	public void testNoWinner() throws Throwable {
		int[]    in =new int[]    { 0,0,0,0,0,0,0,0,0,0 };
		double[] out=new double[] { 0,0,0,0,0,0,0,0,0,0 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}
	
	public void testOneWinner() throws Throwable {
		int[]    in =new int[]    { 0,0,0,0,0,0,0, 1,0,0 };
		double[] out=new double[] { 0,0,0,0,0,0,0,20,0,0 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}	
	
	public void testTwoWinner() throws Throwable {
		int[]    in =new int[]    { 0,0, 2,0,0,0,0, 1,0,0 };
		double[] out=new double[] { 0,0,20,0,0,0,0,18,0,0 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}		

	public void testTie() throws Throwable {
		int[]    in =new int[]    { 100,100,90,80,80,70,60,60,50,40,40 };
		double[] out=new double[] { 19,19,16,13,13,10,1,1,1,1,1 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}	
	
	public void testSuperTie() throws Throwable {
		int[]    in =new int[]    {  1, 1, 1, 1, 1, 1 };
		double[] out=new double[] { 15,15,15,15,15,15 };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}		

	public void testTypical() throws Throwable {
		int[]    in =new int[]    { 1400,0,0,1000,0,800,0,0,20,40,60,0,0,80,120,130 };
		double[] out=new double[] {   20,0,0,  18,0, 16,0,0, 1, 1, 1,0,0,10, 12,14  };
		Assert.assertEquals(in.length,out.length);
		//
		double[] result=new MoJ2005ScoringRules().assignScores(in);
		//
		Assert.assertEquals(out.length,result.length);
		for (int t=0;t<result.length;t++) {
			Assert.assertEquals(out[t],result[t],0.0001);
		}
		//
	}		

	
}
