package nl.moj.test.junit;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;

import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.process.ProcessPool;
import nl.moj.security.SandboxSecurityManager;

import junit.framework.Assert;
import junit.framework.TestCase;


public class JarAssignmentTest extends TestCase {

	public static final String SRC="./data/cases/";
	public static final ThreadGroup evil=new ThreadGroup("evil");
	
	static {
		System.setSecurityManager(new SandboxSecurityManager(evil));
	}
	
	public void testJarFiles() throws Exception {
		File src=new File(SRC);
		File[] jar=src.listFiles(new FileFilter() {
			public boolean accept(File f) {
				if (f.isDirectory()) return false;
				return f.getName().endsWith(".jar");
			}
		});
		//
		Assert.assertFalse(jar.length==0);
		//
		for (int t=0;t<jar.length;t++) try {
			doTestJarFile(jar[t]);
		} catch (Exception ex) {
			throw new Exception("In jar '"+jar[t]+"'",ex);
		}
	}
	
	protected void doTestJarFile(File f) throws Exception {
		JarFileAssignment jfa=new JarFileAssignment(f,new ProcessPool(1),new ApplicationBuilder());
		//
		Assert.assertNotNull(jfa.getName());
		Assert.assertNotNull(jfa.getOperations());
		Assert.assertNotNull(jfa.getDescriptionFileNames());
		Assert.assertNotNull(jfa.getEditableFileNames());
		Assert.assertNotNull(jfa.getSourceCodeFileNames());
		//
		Assert.assertEquals(4,jfa.getOperations().length);
		Assert.assertEquals(1,jfa.getDescriptionFileNames().length);
		Assert.assertEquals(1,jfa.getEditableFileNames().length);
		//
		String[] sc=jfa.getSourceCodeFileNames();
		for (int t=0;t<sc.length;t++) {
			Assert.assertNotNull(sc[t]);
			InputStream in=jfa.getAssignmentFileData(sc[t]);
			Assert.assertNotNull(in);
			in.close();
		}
		//
		Assert.assertNotNull(jfa.getJarFileData());
		Assert.assertEquals(f.length(),jfa.getJarFileData().length);
		//
		// See if the Assignment registered itself with the SSM.
		//
		SandboxSecurityManager ssm=(SandboxSecurityManager)System.getSecurityManager();
		ThreadGroup tg=ssm.getEvilThreadGroup(jfa);
		//
		assertTrue(tg.getName().startsWith(jfa.getName()));
		assertEquals(evil.getName(),tg.getParent().getName());	
		//
	}
	
	public static void main(String[] args) {
		junit.textui.TestRunner.run(JarAssignmentTest.class);
	}	
	
}
