package nl.moj.test.junit;

import junit.framework.Assert;
import junit.framework.TestCase;
import nl.moj.gamerules.CompetitionGameRules;
import nl.moj.model.GameRules;
import nl.moj.test.junit.dummy.DummyClock;
import nl.moj.test.junit.dummy.DummyTeam;

public class CompetitionGameRulesTest extends TestCase {

	private DummyTeam tm1,tm2;
	private DummyClock clk;
	private GameRules tst; 
	
	public void setUp() {
		clk=new DummyClock();
		tst=new CompetitionGameRules(clk);
		tm1=new DummyTeam("A",clk);
		tm2=new DummyTeam("B",clk);
	}
	
	public void testClock() {
		Assert.assertNotNull(tst.getClock(tm1));
		Assert.assertNotNull(tst.getClock(tm2));
		Assert.assertEquals(tst.getClock(tm1),tst.getClock(tm2));
	}

	public void testState() {
		//
		Assert.assertEquals(GameRules.STATE_WAITING,tst.getState(tm1));
		Assert.assertEquals(GameRules.STATE_WAITING,tst.getState(tm2));
		//
		clk.start();
		clk.setTime(0,1);
		//
		Assert.assertEquals(GameRules.STATE_PLAYING,tst.getState(tm1));
		Assert.assertEquals(GameRules.STATE_PLAYING,tst.getState(tm2));
		//
		clk.start();
		clk.setTime(30,0);		
		//
		Assert.assertEquals(GameRules.STATE_FINISHED,tst.getState(tm1));
		Assert.assertEquals(GameRules.STATE_FINISHED,tst.getState(tm2));
		//
	}
	
	public void testTheoreticalScore() {
		for (int m=0;m<30;m++) {
			for (int s=0;s<60;s++) {
				clk.setTime(m,s);
				Assert.assertEquals(clk.getDuration()-m*60-s,tst.getTheoreticalMaximumScore(tm1));
				Assert.assertEquals(clk.getDuration()-m*60-s,tst.getTheoreticalMaximumScore(tm2));
			}
		}
	}
	
	public void testScore() {
		//
		int SUBMITTIME=600;
		//
		tm1.setSubmitTime(SUBMITTIME);
		tm1.setSubmitTestResults(new boolean[] {true});
		//
		Assert.assertEquals(clk.getDuration()-SUBMITTIME,tst.getFinalScore(tm1));
		//
		tm1.setSubmitTestResults(new boolean[] {false});
		//
		Assert.assertEquals(0,tst.getFinalScore(tm1));
		//
	}

	
	
}
