package nl.moj.test.junit;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

import nl.moj.client.io.ActionMessageImpl;
import nl.moj.client.io.AddActionMessageImpl;
import nl.moj.client.io.AssignmentMessageImpl;
import nl.moj.client.io.GoodbyeMessageImpl;
import nl.moj.client.io.HelloMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;
import nl.moj.client.io.UpdateClientStatisticsMessageImpl;
import nl.moj.gamerules.MoJ2006CompetitionGameRules;
import nl.moj.model.Assignment;
import nl.moj.model.Clock;
import nl.moj.model.Round;
import nl.moj.model.Scheduler;
import nl.moj.round.RoundImpl;
import nl.moj.server.socket.SocketGameServer;
import nl.moj.test.junit.dummy.DummyAssignment;
import nl.moj.test.junit.dummy.DummyClock;
import nl.moj.test.junit.dummy.DummyScheduler;
import nl.moj.test.junit.dummy.DummyTeam;
import nl.moj.util.InetAddressUtil;

/**
 * tests the login/wait/playing/logout socket comms between client and server.
 * @author E.Hooijmeijer
 */

public class ClientServerTest extends TestCase {

	private static Round round;
	private static DummyTeam[] team;
	private static Scheduler scheduler;
	private static ThreadGroup serverThreads;
	private static MessageFactory factory = new MessageFactory();

	static {
		Clock clk = new DummyClock();
		Assignment a=new DummyAssignment();
		round = new RoundImpl(a, new MoJ2006CompetitionGameRules(clk));
		team=new DummyTeam[26];
		for (int t=0;t<26;t++) {
			team[t]=new DummyTeam(""+(char)(65+t), clk,a);	
			team[t].setWaiting(true);
			round.addTeam(team[t]);
		}
		scheduler = new DummyScheduler(round);
		serverThreads = new ThreadGroup("Server");
		new SocketGameServer(scheduler, serverThreads);
	}

	private static class Conn {
		Socket socket;
		DataInput in;
		DataOutput out;
	}
	
	
	protected synchronized Conn newConnection() throws IOException {
		Conn r=new Conn();
		//
		// Open Connection.
		//
		r.socket = new Socket(InetAddressUtil.makeInetAddress("127.0.0.1"), 8080);
		// System.out.println("Connecting to "+selectedServer);
		//
		r.in = new DataInputStream(r.socket.getInputStream());
		r.out = new DataOutputStream(r.socket.getOutputStream());
		//
		return r;
	}

	public void testLoginLogout() throws Exception {
		testLoginLogout(0);
	}
	
	protected void testLoginLogout(int tm) throws Exception {
		//
		team[tm].setWaiting(true);
		team[tm].setPlaying(false);
		//
		Conn c=newConnection();
		//
		assertNotNull(c.socket);
		assertNotNull(c.in);
		assertNotNull(c.out);
		//
		new HelloMessageImpl(team[tm].getName(),"Welkom").write(c.out);
		//
		Message msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof AssignmentMessageImpl);
		msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof UpdateClientStatisticsMessageImpl);
		//
		team[tm].setWaiting(false);
		team[tm].setPlaying(true);
		//
		msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof AddActionMessageImpl);
		msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof AddActionMessageImpl);
		msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof AddActionMessageImpl);
		msg=factory.createMessage(c.in);
		assertNotNull(msg);
		assertTrue(msg instanceof UpdateClientStatisticsMessageImpl);
		//
		new ActionMessageImpl("a","b","DummyOp",0,0).write(c.out);
		msg=factory.createMessage(c.in);
		assertTrue(msg instanceof UpdateClientStatisticsMessageImpl);
		//
		new GoodbyeMessageImpl().write(c.out);
		//
		c.socket.close();
		//
		c.socket=null;
		c.in=null;
		c.out=null;
		//
	}
	
	public void testMultiLoginLogout() throws Exception {
		final List faults=Collections.synchronizedList(new ArrayList());
		Thread[] tr=new Thread[team.length];
		for (int t=0;t<tr.length;t++) {
			final int tm=t;
			tr[t]=new Thread(new Runnable() {
				public void run() {
					try {
						testLoginLogout(tm);
					} catch (Throwable t) {
						t.printStackTrace();
						faults.add(t);
					}
				}
			});
		}
		for (int t=0;t<tr.length;t++) tr[t].start();
		boolean r;
		do {
			r=false;
			for (int t=0;t<tr.length;t++) r=r|tr[t].isAlive();
			Thread.sleep(1000);
		} while (r);
		//
		assertEquals(0,faults.size());
		//
	}
	
}
