package nl.moj.test.client.gremlin;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;

import nl.ctrlaltdev.util.Encoder;
import nl.moj.client.io.ActionMessageImpl;
import nl.moj.client.io.HelloMessageImpl;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;

/**
 * A client intended for bulk test. 
 */

public abstract class GremlinClient implements Runnable {

	private static double CHANCETEST=0.4;
	private static double CHANCEINDIVIDUALTESTSET=0.5;

	private Socket mySocket;
	private DataInput myDataInput;
	private DataOutput myDataOutput;
	
	private String myServer;
	private String myTeam;
	private String myPass;
	private String myName;
	
	private MessageFactory myFactory=new MessageFactory();
	
	private int testSetCount=0;
	private double myInterval;
	private String theFile;

    public GremlinClient(String name,String server,int interval,String team,String pass) throws NoSuchAlgorithmException{
        super();
        myName=name;
        myServer=server;
        myTeam=team;
        myPass=Encoder.hash(pass);
        myInterval=interval;
        System.out.println("** Do not Fear, "+name+" is here! **");
    }
    
	/**
	 * creates a new connection with the server and sends the logon
	 * message.
	 */    
	protected synchronized void newConnection() throws IOException {
		 //
		 // Open Connection.
		 //
		 mySocket=new Socket(myServer,8080);
		 //
		 myDataInput=new DataInputStream(mySocket.getInputStream());
		 myDataOutput=new DataOutputStream(mySocket.getOutputStream());
		 //
		 // SignIn.
		 //
		 new HelloMessageImpl(myTeam,myPass).write(myDataOutput);
		 //
	 }
	 /**
	  * returns the data input from the socket. If it does not exist, 
	  * a new connection is made.
	  */    
	 protected synchronized DataInput getDataInput() throws IOException {
		 if ((mySocket==null)||(!mySocket.isConnected())) {
			 newConnection();
		 }
		 return myDataInput;
	 }
	 
	/**
	 * returns the data output from the socket. If it does not exist, 
	 * a new connection is made.
	 */    
	protected synchronized DataOutput getDataOutput() throws IOException {
		if ((mySocket==null)||(!mySocket.isConnected())) {
			 newConnection();
		}
	 	return myDataOutput;
	}    
	 
	/** override the implement other cases */
	public abstract String generateSource(); 
    
    public void run()  {
    	//
    	int time=0;
    	int lastTime=0;
    	int nextTime=0;
    	//
    	try {
    		Thread.sleep((int)(500.0*Math.random()));
    	} catch (InterruptedException ex) {
    		//
    	}
    	//
    	boolean goOn=true;
    	while (goOn) {
    		//
    		try {
    			//
				DataInput in=getDataInput();
				//
				// Do something every 5..15 secs.
				//
				if ((time<=nextTime)&&(time!=lastTime)&&(testSetCount>=0)&&(theFile!=null)) {
					//
					nextTime=time-(5+(int)(myInterval*Math.random()));
					lastTime=time;
					//
					String data=generateSource();
					String action;
					int idx=-1;
					if (Math.random()>CHANCETEST) {
						action="Compile";
					} else if (time<60*Math.random()) {
						action="Submit";
					} else {
						action="Test";
						if (Math.random()<CHANCEINDIVIDUALTESTSET) {
							idx=(int)(Math.random()*testSetCount);
							if (idx==testSetCount) idx=idx-1;
						}
					}
					//
					DataOutput out=getDataOutput();
					System.out.println(myName+" Performing "+action+" "+idx);
					new ActionMessageImpl(theFile,data,action,idx,64).write(out);
					((DataOutputStream)out).flush();					
					//
					//
				}
				//
				Message msg=myFactory.createMessage(in);
				//
				switch (msg.getType()) {
					case Message.MSG_CONSOLE :
						Message.Console con=(Message.Console)msg; 
						System.out.println(myName+" Console : "+con.getContent());
						break;					
					case Message.MSG_EDITOR : 
						Message.Editor ed=(Message.Editor)msg; 
						if (!ed.isReadOnly()) {
							theFile=ed.getFileName();
						}
						System.out.println(myName+" Editor : "+ed.getFileName());
					break;
					case Message.MSG_ADDACTION : 
						Message.AddAction add=(Message.AddAction)msg;
						System.out.println(myName+" Add action : "+add.getAction());
						break;
					case Message.MSG_UPDATE_CLIENT :
						Message.UpdateClientStatistics upd=(Message.UpdateClientStatistics)msg;
						System.out.println(myName+" Update : "+upd.getSecondsRemaining());
						time=upd.getSecondsRemaining();
						if (nextTime==0) nextTime=time-10-((int)(myInterval*Math.random()));
						break;					
					case Message.MSG_TESTSET :
						Message.TestSet tstset=(Message.TestSet)msg;
						testSetCount=tstset.getCount();
						break;
					case Message.MSG_UNKNOWNUSERPASSWORD :
						System.out.println(myName+" Unknown user or password");
						goOn=false;
						break;
					case Message.MSG_PROTOCOLVERSIONMISMATCH :
						System.out.println(myName+" Protocol version mismatch.");
						goOn=false;
						break;
					case Message.MSG_ANIMATION : 
						break;
					case Message.MSG_ASSIGNMENT :
						break;
					/** all other messages : close the connection */
					default : throw new IOException(myName+" UnExcpected Message : "+msg.getType());
				} 				
				//				
    		} catch (IOException ex) {
    			ex.printStackTrace();
    			goOn=false;
    		}
			//    		
    	}
    	//
    }
	
}
