package nl.moj.test.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;

import nl.moj.client.anim.Anim;
import nl.moj.client.anim.LayeredAnim;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AnimTest  extends TestCase {

	protected DataInput writeAndReadBack(Anim anim) throws Exception {
		// 
		ByteArrayOutputStream baos=new ByteArrayOutputStream();
		DataOutput out=new DataOutputStream(baos);
		anim.write(out);
		return new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
		//
	}	
	
	public void testAnimSerialisation() throws Exception {
		LayeredAnim a=LayeredAnimTestIU.createAnim();
		DataInput in=writeAndReadBack(a);
		//
		LayeredAnim copy=new LayeredAnim();
		copy.read(in);
		//
		Assert.assertEquals(a.getFrameCount(),copy.getFrameCount());
		for (int t=0;t<a.getFrameCount();t++) {
			Assert.assertNotNull(a.current());
			Assert.assertNotNull(copy.current());
			a.next();
			copy.next();
		}
		//
	}
	
	public void testShapes() {
		//
		LayeredAnim a=new LayeredAnim();
		Assert.assertEquals(0,a.createBitmapResource().getId());
		Assert.assertEquals(1,a.createShapeResource().getId());
		Assert.assertEquals(3,a.createSpriteResource(a.createShapeResource()).getId());
		Assert.assertEquals(4,a.createMapResource().getId());
		//
	}
	
	public void testMapResource() throws Exception {
		//
		LayeredAnim a=LayeredAnimTestIU.createMapAnim();
		//
		DataInput in=writeAndReadBack(a);
		//
		LayeredAnim copy=new LayeredAnim();
		copy.read(in);		
		//
		Assert.assertEquals(a.getFrameCount(),copy.getFrameCount());
		for (int t=0;t<a.getFrameCount();t++) {
			Assert.assertNotNull(a.current());
			Assert.assertNotNull(copy.current());
			a.next();
			copy.next();
		}
		//
		
	}
	
	
}
