package nl.moj.sfx;

import java.io.File;

import nl.ctrlaltdev.sound.SoundPlayer;
import nl.moj.model.Clock;

public class SoundEffects implements Clock.Notification {

	private SoundPlayer myPlayer;

	public SoundEffects() {
		super();
		//
		try {
			myPlayer=new SoundPlayer(200);
		} catch (SoundPlayer.SoundPlayerException ex) {
			myPlayer=null;
		}
	}

	public void clockStarted() {
		if (myPlayer!=null) try {
			myPlayer.play(new File("./data/sfx/gong.wav"));
		} catch (Exception ex) {
			System.err.println(ex);
		}
	}
	public void clockStopped() {
		if (myPlayer!=null) try {
			myPlayer.play(new File("./data/sfx/gong.wav"));
		} catch (Exception ex) {
			System.err.println(ex);
		}
	}
	public void minutePassed(int remaining) {
		if (myPlayer!=null) try {
			if ((remaining<=5)&&(remaining!=0)) {
				myPlayer.play(new File("./data/sfx/alarm.wav"));
			} else {
				//myPlayer.play(new File("./data/sfx/tick.wav"));
			}
		} catch (Exception ex) {
			System.err.println(ex);
		}
	}
	
	public void submitFailed() {
		if (myPlayer!=null) try {
			myPlayer.play(new File("./data/sfx/buzzer.wav"));
		} catch (Exception ex) {
			System.err.println(ex);
		}
	}
	
	public void submitSuccess() {
		if (myPlayer!=null) try {
			myPlayer.play(new File("./data/sfx/dowah.wav"));
		} catch (Exception ex) {
			System.err.println(ex);
		}
	}
	public void clockReset() {
		
	}	
	public void clockFinished() {
		
	}

}
