package nl.moj.client.codecompletion;

import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.statement.Declaration;

/**
 * Holds the code to complete 
 */

public class PartialCode {

	private String codeToComplete;
	private String[] dotSeparated; 
	private boolean newInstance;
	private Declaration[] knownDeclarations;
	private CodeNode myRoot;
	private CodeNode foundRoot;  
	private boolean variable;

	/**
	 * @param codeToComplete the code to complete
	 * @param newInstance true if the code is linked to the new keyword.
	 */
	public PartialCode(String codeToComplete,boolean newInstance) {
		this.codeToComplete=codeToComplete;
		this.newInstance=newInstance;
		//System.out.println("Code to Complete : "+codeToComplete);
		dotSeparated=Tool.cutForEach(codeToComplete,".");		
	}
	
	public void setContext(CodeNode root,Declaration[] decl) {
		myRoot=root;
		knownDeclarations=decl;
	}
	
	public int length() { 
		return codeToComplete.length();
	}
	
	public String toString() {
		return codeToComplete;
	}
	
	/**
	 * Resolve attempts to resolve the
	 * various parts before the actual 
	 */
	public void resolve() {
		//
		if (dotSeparated.length<=1) return;
		//
		// See if there is a complete type def.
		//
		CodeNode root=myRoot;
		// System.out.println(myRoot.render());
		//
		for (int t=0;t<dotSeparated.length-1;t++) {
			//System.out.println("CURRENT : "+dotSeparated[t]);		
			CodeNode newRoot=root.contains(dotSeparated[t]);
			//System.out.println("newRoot = "+newRoot);
			if (newRoot==null) {
				for (int y=0;y<knownDeclarations.length;y++) {
					if (dotSeparated[t].equals(knownDeclarations[y].getName())) {
						//System.out.println("declaration = "+knownDeclarations[y]);
						variable=true;
						String[] type=Tool.cutForEach(knownDeclarations[y].getType(),".");
						CodeNode troot=myRoot;
						for (int z=0;z<type.length;z++) {
							troot=troot.contains(type[z]);
							if (troot==null) return;
						}
						newRoot=troot;
					}
				}
			}
			root=newRoot;
			//System.out.println("root = "+root);
			if (root==null) return;
		} 
		//
		//System.out.println(root);
		foundRoot=root;
		//
	}
	
	public boolean isStatic() {
		return (newInstance)||(!variable);
	}
	
	public CodeNode getRoot() {
		if (foundRoot==null) return myRoot;
		return foundRoot;
	}
	public String getRemainderToComplete() {
		return dotSeparated[dotSeparated.length-1];
	}
	public String getPrefix() {
		StringBuffer sb=new StringBuffer();
		for (int t=0;t<dotSeparated.length-1;t++) {
			sb.append(dotSeparated[t]);
			sb.append(".");
		}
		return sb.toString();
	}
	
}
