package nl.moj.assignment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Tester;
import nl.moj.operation.Compile;
import nl.moj.operation.Save;
import nl.moj.operation.Submit;
import nl.moj.operation.Test;
import nl.moj.process.ProcessPool;
import nl.moj.security.DefaultSecurityDelegate;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.FileArrayClassLoader;

/**
 * Basically a dirty hack to make it possible to run Assignments from out
 * of the eclipse workspace. Any file that ends with 'Impl.java' is marked
 * as editable. 
 * @deprecated use the MoJEclipse plugin with integrated facilities.
 */

public class EclipseWorkspaceAssignment implements Assignment {

	private static class ExtensionFilter implements FileFilter {
		public String ext;
		public ExtensionFilter(String ext) { this.ext=ext.toLowerCase(); } 	
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) return false;
            return pathname.getName().toLowerCase().endsWith(ext);
        }
	}

	private static final String EXT_JAVA=".java";
	private static final String EXT_CLASS=".class";
	private static final String EXT_TXT=".txt";
	private static final String EXT_IMG=".jpg";

	private List    javaFiles=new ArrayList();
	private List    textFiles=new ArrayList();
	private String[] editableFiles;
	private String   name;
	private Tester.SecurityDelegate delegate;
	private Operation[] theOps;
	
	private Map fileNameTranslation=new HashMap();
	private boolean isCombined;
	
	private byte[] iconImage;
	private byte[] sponsorImage;
	
	private String submitClass;
	private String testClass;
	private int    submitClassTimeout=20;
	private int    testClassTimeout=15;

	public EclipseWorkspaceAssignment(File projectRoot,ProcessPool pool,ApplicationBuilder parent) throws Exception {
		if (!projectRoot.isDirectory()) throw new IOException("Need a workspace directory as starting point.");
		//
		// Determine if we're using src/bin dirs or just a plain project.
		//
		File srcDir=new File(projectRoot,"src");
		File binDir=new File(projectRoot,"bin");
		boolean srcExists=srcDir.exists()&&srcDir.isDirectory();
		boolean binExists=binDir.exists()&&binDir.isDirectory();
		if (srcExists^binExists) throw new IOException("Either have both src and bin dirs or none."); 
		isCombined=srcExists&&binExists;
		if (!isCombined) {
			srcDir=projectRoot;
			binDir=projectRoot;
		}
		//
		name=projectRoot.getName();
		//
		// Find the files.
		//
		File[] java=srcDir.listFiles(new ExtensionFilter(EXT_JAVA));
		File[] txt=srcDir.listFiles(new ExtensionFilter(EXT_TXT));
		File[] bin=binDir.listFiles(new ExtensionFilter(EXT_CLASS));
		File[] images=binDir.listFiles(new ExtensionFilter(EXT_IMG));
		//
		theOps=new Operation[4];
		theOps[0]=new Save(pool);
		theOps[1]=new Compile(pool);
		//
		ClassLoader facl=new FileArrayClassLoader(bin,this.getClass().getClassLoader());
		for (int t=0;t<bin.length;t++) {
			String className=bin[t].getName();
			className=className.substring(0,className.lastIndexOf('.'));
			Class c=facl.loadClass(className);
			boolean removeSource=false;
			boolean removeBin=false;
			// 
			// Find out what kind of class it is.
			//
			// Interface should always be included in source form and
			// as a .class file.
			//
			if (c.isInterface()) {
				//
			} 
			//
			// If Tester, create the Test and Submit operations from it.
			//				
			if (Tester.Testable.class.isAssignableFrom(c)) {
				submitClass=c.getName();
				testClass=c.getName();
				theOps[2]=new Test(this,pool,bin);
				theOps[3]=new Submit(this,pool,bin);
				removeSource=true;
				// 
			}
			// 
			// Security Delegate : instantiate and use.
			//
			if (Tester.SecurityDelegate.class.isAssignableFrom(c)) {
				//
				ApplicationBuilder ab=new ApplicationBuilder(parent);
				ab.build(new Class[] {c});
				delegate=(Tester.SecurityDelegate)ab.get(Tester.SecurityDelegate.class);
				if (delegate==null) throw new NullPointerException("Error getting '"+c.getName()+"' as Tester.SecurityDelegate");
				removeSource=true;
				//				
			}
			//
			if (removeBin) bin[t]=null;
			if (removeSource) remove(java,c);
			//
		}
		//
		// Actually, this is too late as the Test and Sumbit are already created.
		// But as its for testing purposes, who cares :-)
		//
		registerAssignmentWithSecurityManager();	
		//
		// make java - file mapping and determine editable (Impl) files. 
		//
		List editable=new ArrayList();
		for (int t=0;t<java.length;t++) {
			if (java[t]!=null) {
				fileNameTranslation.put(java[t].getName(),java[t]);
				javaFiles.add(java[t].getName());
				if (java[t].getName().endsWith("Impl.java")) editable.add(java[t].getName());
			}
		}
		editableFiles=(String[])editable.toArray(new String[editable.size()]);
		//
		// make txt - file mapping.
		//
		for (int t=0;t<txt.length;t++) {
			if (txt[t]!=null) {
				fileNameTranslation.put(txt[t].getName(),txt[t]);
				textFiles.add(txt[t].getName());
			}
		}
		//
		// Some more checks.
		//
		if (theOps[2]==null) throw new NullPointerException("Missing Tester.Testable implementation.");
		if (delegate==null) delegate=new DefaultSecurityDelegate();
		//
		for (int t=0;t<images.length;t++) {
			if (images[t].getName().startsWith("sponsor-")) {
				if (sponsorImage!=null) throw new IOException("Multiple sponsor images.");
				sponsorImage=Tool.readBinary(new FileInputStream(images[t]),(int)images[t].length());
			}
			if (images[t].getName().startsWith("icon-")) {
				if (sponsorImage!=null) throw new IOException("Multiple assignment icon images.");
				iconImage=Tool.readBinary(new FileInputStream(images[t]),(int)images[t].length());
			}
		}
		//
	}
	
	protected void registerAssignmentWithSecurityManager() {
		SandboxSecurityManager ssm=(SandboxSecurityManager)System.getSecurityManager();
		ssm.registerAssignment(this);		
	}
	
	public String getDisplayName() { return name; }
	
	protected void remove(File[] f,Class c) {
		String javaName=c.getName()+EXT_JAVA;
		for (int t=0;t<f.length;t++) {
			if (f[t]==null) continue;
			if (f[t].getName().equals(javaName)) f[t]=null;
		}		
	}	


	public InputStream getAssignmentFileData(String name) throws IOException {
		File f=(File)fileNameTranslation.get(name);
		if (f==null) throw new IOException("'"+name+"' does not exist.");
		return new FileInputStream(f);
	}
	public String[] getDescriptionFileNames() {
		return (String[])textFiles.toArray(new String[textFiles.size()]);
	}
	public String[] getSourceCodeFileNames() {
		return (String[])javaFiles.toArray(new String[javaFiles.size()]);
	}
	public Operation[] getOperations() {
		return (Operation[])Tool.copy(theOps);
	}
	
	public Tester.SecurityDelegate getSecurityDelegate() { return delegate;}	
	public String[] getEditableFileNames() { return (String[])Tool.copy(editableFiles); }
	public String getName() { return name; }
	public boolean isDescriptionRenderedInMonospaceFont() { return true; }
	
	public String getAuthor() {
		return "Eclipse Workspace";
	}
	public byte[] getIcon() {
		return iconImage;
	}
	public byte[] getSponsorImage() {
		return sponsorImage;
	}
	
	public String getSubmitClass() {
		return submitClass;
	}
	public int getSubmitClassTimeout() {
		// TODO Auto-generated method stub
		return submitClassTimeout;
	}
	public String getTestClass() {
		// TODO Auto-generated method stub
		return testClass;
	}
	public int getTestClassTimeout() {
		// TODO Auto-generated method stub
		return testClassTimeout;
	}
	
	public int getDuration() {
		return 30;
	}

}
