import java.io.File;
import java.util.Date;

import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.clock.SimpleClock;
import nl.moj.gamerules.MoJ2006CompetitionGameRules;
import nl.moj.model.Assignment;
import nl.moj.model.GameRules;
import nl.moj.model.Round;
import nl.moj.process.ProcessPool;
import nl.moj.round.RoundFactory;
import nl.moj.scheduler.ContinuousScheduler;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.server.socket.SocketGameServer;
import nl.moj.workspace.factory.LocalWorkspaceFactory;

public class TestContinuousScheduler {

	public static void main(String[] args) throws Exception {
		//
		ThreadGroup evilThreadGroup=new ThreadGroup("evil");
		//
		System.setSecurityManager(new SandboxSecurityManager(evilThreadGroup));		
		//
		LocalWorkspaceFactory lwf=new LocalWorkspaceFactory();
		ContinuousScheduler cs=new ContinuousScheduler(lwf);
		//
		RoundFactory rf=new RoundFactory();
		//
		ProcessPool pool=new ProcessPool(8);
		Assignment a=new JarFileAssignment(new File("./data/cases/brainCase.jar"),pool,new ApplicationBuilder());
		GameRules gr=new MoJ2006CompetitionGameRules(new SimpleClock(a.getDuration()));
		String[] teams=new String[] {"ATeam","BTeam" };
		//
		Round rnd=rf.createRound(a,gr,teams);
		//
		cs.addToSchedule(rnd,new Date(new Date().getTime()+1000L));
		//
		new SocketGameServer(cs,new ThreadGroup("Clients"));
		//
	}
	
}
