package nl.moj.client.codecompletion;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementException;
import nl.moj.client.codecompletion.statement.Declaration;

/**
 *
 */
public class CodeCompletion {

	private List mySources;
	private CodeNodeFactory myCNF;

    public CodeCompletion() {
        super();
        mySources=new ArrayList();
        myCNF=new CodeNodeFactory();
    }
    
    /**
     * Adds a piece of static (non editable) source code for future reference.
     */    
    public void addStaticSource(String source) throws StatementException {
    	mySources.add(new SourceCodeCompletion(source));
    }

	/**
	 * Identifies the part of the source that needs to be completed.  
	 */
	public PartialCode getPartToComplete(String line) {
		if (line.length()==0) return new PartialCode("",false);
		int idx1=line.lastIndexOf("(");
		if (idx1>=0) line=line.substring(idx1+1);		
		int idx2=line.lastIndexOf(",");
		if (idx2>=0) line=line.substring(idx2+1);
		int idx3=line.lastIndexOf("=");
		if (idx3>=0) line=line.substring(idx3+1);
		int idx4=line.lastIndexOf("<");
		if (idx4>=0) line=line.substring(idx4+1);
		int idx5=line.lastIndexOf(">");
		if (idx5>=0) line=line.substring(idx5+1);
		//
		String[] words=Tool.cut(line," ");
		if (words.length==0) return new PartialCode("",false);
		boolean isNewInstance=((words.length>1)&&(words[words.length-2].equals("new")));
		//
		return new PartialCode(words[words.length-1],isNewInstance);
		//
	}
	
    public String[] getCompletions(String contextSource,int contextPosition,PartialCode wordToComplete) {
    	Set result=new TreeSet();
    	CodeNode root=myCNF.createRoot();
    	//
    	// Parse the current source and add it to the root node.
    	// 	
		SourceCodeParser parse=null;
    	try {
    		parse=new SourceCodeParser(contextSource);
    		new SourceCodeCompletion(parse).addToCodeTree(myCNF,root);
    	} catch (StatementException ex) {
    		//System.out.println(ex);
    	}
    	//
    	// Add static sources to the root node.
    	//
    	for (int t=0;t<mySources.size();t++) {
    		SourceCodeCompletion scc=(SourceCodeCompletion)mySources.get(t);
    		scc.addToCodeTree(myCNF,root);
    	}
    	//
    	if (parse!=null) {
			//
			Statement stm=parse.getStatementAt(contextPosition);
			//    		
			List varList=new ArrayList();
			parse.getJavaFile().findAccessibleVariableDeclarations(stm,varList);
			Declaration[] vars=(Declaration[])varList.toArray(new Declaration[varList.size()]);
			//
			// Add known variables for this context.
			//
			wordToComplete.setContext(root,vars);
			//
			wordToComplete.resolve();
    		//
    	} else {
    		wordToComplete.setContext(root,new Declaration[0]);
    	}
    	//
    	//System.out.println(root.render());
		//
    	CodeNode cn=wordToComplete.getRoot();
    	Set tmp=new TreeSet();
    	//System.out.println("Searching for : "+wordToComplete.getRemainderToComplete()+", static="+wordToComplete.isStatic());
    	cn.find(wordToComplete.getRemainderToComplete(),true,wordToComplete.isStatic(),tmp);
    	//
    	String prefix=wordToComplete.getPrefix();
    	CodeNode[] cna=(CodeNode[])tmp.toArray(new CodeNode[tmp.size()]);
    	for (int t=0;t<cna.length;t++) {
    		if (cna[t].getName().length()>0) {
				result.add(prefix+cna[t].getName());
    		}
    	}
    	//
    	return (String[])result.toArray(new String[result.size()]);
    }

}
