package nl.moj.test.junit.workspace;

import java.io.File;

import nl.ctrlaltdev.io.OutputRedirector.Target;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.process.ProcessPool;
import nl.moj.process.ProcessPool.ProcessListener;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.workspace.factory.LocalWorkspaceFactory;
import nl.moj.workspace.factory.WorkspaceFactory;
import junit.framework.Assert;
import junit.framework.TestCase;

public class WorkspaceTester extends TestCase {

	private static class Stub implements Target,ProcessListener {
		public boolean complete,executing,queued;
		public int msgs;
		public Runnable result;
		public void append(String context, String s) {
			msgs++;
		}
		public void complete(Runnable r) {
			complete=true;
			result=r;
		}
		public void executing(Runnable r) {
			executing=true;
		}
		public void queued(Runnable r) {
			queued=true;
		}
		public void reset() {
			complete=false;
			executing=false;
			queued=false;
			result=null;
			msgs=0;
		}
	}
	
	private static WorkspaceFactory wsFactory;
	private Assignment testAssignment;
	
	public WorkspaceTester(String s) { 
		super(s);
	}
	
	protected void setUp() throws Exception {
		if (wsFactory==null) wsFactory=createWorkspaceFactory();
		System.setSecurityManager(new SandboxSecurityManager(new ThreadGroup("Evil")));
		testAssignment=new JarFileAssignment(new File("./data/cases/hanoiCase.jar"),new ProcessPool(8),new ApplicationBuilder());
	}
	
	/** override for other implementations */
	public WorkspaceFactory createWorkspaceFactory() {
		return new LocalWorkspaceFactory();
	}
	
	public void testFiles() throws Exception {
		//
		Stub s=new Stub();
		//
		Workspace ws=wsFactory.createWorkspace("JUnit",s,s);
		try {
			//
			ws.loadAssignment(testAssignment,false);		
			//
			int rocnt=0;
			//
			String[] f=ws.getEditorFiles();
			for (int t=0;t<f.length;t++) {
				Assert.assertTrue(ws.getContents(f[t])!=null);
				Assert.assertEquals(ws.isJava(f[t]),f[t].endsWith(".java"));
				Assert.assertEquals(ws.isMonospaced(f[t]),f[t].endsWith(".txt"));
				if (!ws.isReadOnly(f[t])) rocnt++;
			}
			Assert.assertEquals(1,rocnt);
			//
		} finally {
			//
			ws.dispose();
			//
		}
	}
	
	public void testOperations() throws Exception {
		//
		Stub s=new Stub();
		//
		Workspace ws=wsFactory.createWorkspace("JUnit",s,s);
		try {
			//
			ws.loadAssignment(testAssignment,false);		
			//
			int submitCnt=0;
			//
			Operation[] op=ws.getAllOperations();
			for (int t=0;t<op.length;t++) {
				Assert.assertNotNull(op[t].getName());
				Assert.assertNotNull(op[t].getTooltip());
				if (op[t].isSubmit()) submitCnt++;
				if (op[t].isSubmit()) {
					Assert.assertTrue(op[t].needsConfirm());
				}
			}
			Assert.assertEquals(1,submitCnt);
			//
		} finally {
			//
			ws.dispose();
			//
		}
	}
	
	public void testResume() throws Exception {
		//
		String name=null;
		String testMsg="TEST 1 2 3\n";
		Stub s=new Stub();
		//
		Workspace ws=wsFactory.createWorkspace("JUnit",s,s);
		try {
			//
			ws.loadAssignment(testAssignment,false);
			//

			String[] f=ws.getEditorFiles();
			for (int t=0;t<f.length;t++) {
				if (!ws.isReadOnly(f[t])) name=f[t];
			}
			//
			int cnt=0;
			s.reset();
			ws.perform(ws.getOperationByName("Save"),new ContextImpl(name,testMsg,-1));
			do {
				Thread.sleep(100);
				ws.update();
				cnt++;
			} while ((!s.complete)&&(cnt<30));
			Assert.assertTrue(s.complete);
			//
			Assert.assertEquals(ws.getContents(name),testMsg);
		} finally {
			//
			ws.suspend();
			ws=null;
			//
		}
		//
		// See if the saved contents are still there.
		//
		ws=wsFactory.createWorkspace("JUnit",s,s);
		try {
			//
			ws.loadAssignment(testAssignment,true);
			//
			Assert.assertEquals(ws.getContents(name),testMsg);
			//
		} finally {
			//
			ws.dispose();
			//
		}
	}
	
	public void testLifecycle() throws Exception {
		//
		Stub s=new Stub();
		//
		Workspace ws=wsFactory.createWorkspace("JUnit",s,s);
		try {
			//
			String srcName=null;
			String srcContent=null;
			ws.loadAssignment(testAssignment,false);
			String[] editorFiles=ws.getEditorFiles();
			for (int t=0;t<editorFiles.length;t++) { 
				if (!ws.isReadOnly(editorFiles[t])) {
					srcName=editorFiles[t];
					srcContent=ws.getContents(editorFiles[t]);
				}
			}
			//
			Assert.assertTrue(srcName!=null);
			Assert.assertTrue(srcContent!=null);
			//
			Operation[] ops=ws.getAllOperations();
			for (int t=0;t<ops.length;t++) {
				s.reset();
				int cnt=0;
				ws.perform(ops[t],new ContextImpl(srcName,srcContent,-1));	
				do {
					Thread.sleep(100);
					ws.update();
					cnt++;
				} while ((!s.complete)&&(cnt<30));
				Assert.assertTrue(s.queued);
				Assert.assertTrue(s.executing);
				Assert.assertTrue(s.complete);
				Assert.assertTrue(s.result!=null);
				//
				if (ops[t].isSubmit()) {
					Assert.assertTrue(s.result instanceof Team.TestResults);
				} else if (ops[t].getName().equals("Test")) {
					Assert.assertTrue(s.result instanceof Team.TestResults);
				} else if (ops[t].getName().equals("Compile")) {
					Assert.assertTrue(s.result instanceof Team.CompileResults);
				}
			}
		} finally {
			//
			ws.dispose();
			//
		}
	}
	
	public static void main(String[] args) {
		SimpleLogFormatter.clearLogConfig();		
		junit.textui.TestRunner.run(WorkspaceTester.class);
		System.exit(0);
	}	

}
