package nl.moj.test.junit.workspace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;

import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.client.anim.Anim;
import nl.moj.model.Operation;
import nl.moj.model.Tester;
import nl.moj.operation.ContextImpl;
import nl.moj.process.ProcessPool;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.TesterImpl;
import nl.moj.test.client.LayeredAnimTestIU;
import nl.moj.workspace.io.AbstractWorkspaceMessage;
import nl.moj.workspace.io.AssignmentMessage;
import nl.moj.workspace.io.ConsoleMessage;
import nl.moj.workspace.io.ContentsReply;
import nl.moj.workspace.io.ContentsRequest;
import nl.moj.workspace.io.GoodbyeMessage;
import nl.moj.workspace.io.Message;
import nl.moj.workspace.io.PerformMessage;
import nl.moj.workspace.io.ProcessStateMessage;
import nl.moj.workspace.io.WorkspaceMessageFactory;
import junit.framework.Assert;
import junit.framework.TestCase;


public class WorkspaceMessageTester extends TestCase {

	protected DataInput writeAndReadBack(AbstractWorkspaceMessage msg) throws Exception {
		// 
		ByteArrayOutputStream baos=new ByteArrayOutputStream();
		DataOutput out=new DataOutputStream(baos);
		msg.write(out);
		return new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
		//
	}

	public void testAssignment() throws Exception {
		String team="Test";
		boolean resume=false;
		System.setSecurityManager(new SandboxSecurityManager(new ThreadGroup("xxx")));
		JarFileAssignment jfa=new JarFileAssignment(new File("./data/cases/hanoiCase.jar"),new ProcessPool(1),new ApplicationBuilder());
		DataInput in=writeAndReadBack(new AssignmentMessage(team,resume,jfa));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.Assignment);
		Assert.assertEquals(team,((Message.Assignment)o).getTeamName());
		Assert.assertEquals(resume,((Message.Assignment)o).isResumeMode());
		byte[] bytes=((Message.Assignment)o).getJarAssignment();
		byte[] orig=jfa.getJarFileData();
		//
		Assert.assertNotNull(bytes);
		Assert.assertEquals(bytes.length,orig.length);
		for (int t=0;t<orig.length;t++) {
			Assert.assertEquals(orig[t],bytes[t]);
		}
		//
	}
	
	public void testConsole() throws Exception {
		String console="doIt";
		String content="blah etc.";
		//
		DataInput in=writeAndReadBack(new ConsoleMessage(console,content));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.Console);
		Assert.assertEquals(console,((Message.Console)o).getContext());
		Assert.assertEquals(content,((Message.Console)o).getContent());
		//		
	}
	
	public void testContentsRequest() throws Exception {
		String name="wodka.java";
		//
		DataInput in=writeAndReadBack(new ContentsRequest(name));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.ContentsRequest);
		Assert.assertEquals(name,((Message.ContentsRequest)o).getName());
		//		
	}

	public void testContentsReply() throws Exception {
		String name="wodka.java";
		String content="10 print hoi 20 goto 10";
		//
		DataInput in=writeAndReadBack(new ContentsReply(name,content));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.ContentsReply);
		Assert.assertEquals(name,((Message.ContentsReply)o).getName());
		Assert.assertEquals(content,((Message.ContentsReply)o).getContents());
		//		
	}
	
	public void testGoodbye() throws Exception {
		boolean dispose=false;
		//
		DataInput in=writeAndReadBack(new GoodbyeMessage(dispose));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.Goodbye);
		//
		Assert.assertEquals(dispose,((Message.Goodbye)o).isDispose());
		//
	}
	
	public void doProcessState(int state,String name,boolean success,Tester.TestResult results) throws Exception {
		//
		DataInput in=writeAndReadBack(new ProcessStateMessage(state,name,success,results));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.ProcessState);
		//
		Assert.assertEquals(state==Message.ProcessState.STATE_QUEUED,((Message.ProcessState)o).isQueued());
		Assert.assertEquals(state==Message.ProcessState.STATE_EXECUTING,((Message.ProcessState)o).isExecuting());
		Assert.assertEquals(state==Message.ProcessState.STATE_FINISHED,((Message.ProcessState)o).isFinished());
		//
		Assert.assertEquals(name,((Message.ProcessState)o).getOperationName());
		//
		if (results!=null) {
			Assert.assertNotNull(((Message.ProcessState)o).getTestResults());
			Assert.assertEquals(results.isFaulty(),((Message.ProcessState)o).getTestResults().isFaulty());
			Assert.assertEquals(results.isOk(),((Message.ProcessState)o).getTestResults().isOk());
			Assert.assertEquals(results.isUnknown(),((Message.ProcessState)o).getTestResults().isUnknown());
			Assert.assertEquals(results.getResults().length,((Message.ProcessState)o).getTestResults().getResults().length);
			Assert.assertEquals(results.getScore().length,((Message.ProcessState)o).getTestResults().getScore().length);
			//
			for (int t=0;t<results.getResults().length;t++) {
				Assert.assertEquals(results.getResults()[t],((Message.ProcessState)o).getTestResults().getResults()[t]);
			}
			for (int t=0;t<results.getScore().length;t++) {
				Assert.assertEquals(results.getScore()[t],((Message.ProcessState)o).getTestResults().getScore()[t]);
			}
			//
			if (results.getAnimationOutput()!=null) {
				Assert.assertNotNull(((Message.ProcessState)o).getTestResults().getAnimationOutput());
				Anim[] inAnim=results.getAnimationOutput();
				Anim[] outAnim=((Message.ProcessState)o).getTestResults().getAnimationOutput();
				Assert.assertEquals(inAnim.length,outAnim.length);
				for (int t=0;t<inAnim.length;t++) {
					if (inAnim[t]==null) {
						Assert.assertNull(outAnim[t]);
					} else {
						Assert.assertNotNull(outAnim[t]);
					}
				}
			} else {
				Assert.assertNull(((Message.ProcessState)o).getTestResults().getAnimationOutput());
			}
			//
		} else {
			Assert.assertNull(((Message.ProcessState)o).getTestResults());
		}
	}

	public void testProcessState() throws Exception {
		Tester.TestResult results=new TesterImpl.TestResultImpl(new int[] {1,0},new Anim[] {null,null });
		//
		doProcessState(Message.ProcessState.STATE_QUEUED,"A",false,null);
		doProcessState(Message.ProcessState.STATE_EXECUTING,"A",false,null);
		doProcessState(Message.ProcessState.STATE_FINISHED,"A",true,results);
		//
		results=new TesterImpl.TestResultImpl(new int[] {1,0,-1},new Anim[] {null,null,null});
		doProcessState(Message.ProcessState.STATE_QUEUED,"B",true,results);
		doProcessState(Message.ProcessState.STATE_EXECUTING,"B",true,results);
		doProcessState(Message.ProcessState.STATE_FINISHED,"B",true,results);
		//
		results=new TesterImpl.TestResultImpl(new int[] {1,1,1},new Anim[] {null,null,null});
		doProcessState(Message.ProcessState.STATE_QUEUED,"C",false,results);
		doProcessState(Message.ProcessState.STATE_EXECUTING,"C",false,results);
		doProcessState(Message.ProcessState.STATE_FINISHED,"C",false,results);
		//
		results=new TesterImpl.TestResultImpl(new int[] {0},new Anim[] { LayeredAnimTestIU.createAnim() });
		doProcessState(Message.ProcessState.STATE_QUEUED,"D",false,results);
		doProcessState(Message.ProcessState.STATE_EXECUTING,"D",false,results);
		doProcessState(Message.ProcessState.STATE_FINISHED,"D",false,results);
		//
	}
	
	protected void doPerform(String operation,Operation.Context ctx) throws Exception {
		DataInput in=writeAndReadBack(new PerformMessage(operation,ctx));
		Object o=new WorkspaceMessageFactory().createMessage(in);
		//
		Assert.assertTrue(o instanceof Message.Perform);
		//
		Message.Perform perform=((Message.Perform)o);
		//
		Assert.assertEquals(operation,perform.getOperationName());
		if (ctx!=null) {
			Assert.assertNotNull(perform.getContext());
			Assert.assertEquals(ctx.getIndex(),perform.getContext().getIndex());
			String[] no=ctx.getNames();
			String[] nn=perform.getContext().getNames();
			Assert.assertEquals(no.length,nn.length);
			for (int t=0;t<no.length;t++) {
				Assert.assertEquals(no[t],nn[t]);
				Assert.assertEquals(ctx.getContents(no[t]),perform.getContext().getContents(nn[t]));
			}
		} else {
			Assert.assertNull(perform.getContext());
		}
	}
	
	public void testPerform() throws Exception {
		//
		doPerform("Test1",new ContextImpl("A","BCD",-1));
		doPerform("Test2",new ContextImpl("AX","BCDE",0));
		doPerform("Test3",new ContextImpl("AZ","BCDF",1));
		//
		doPerform("Test4",new ContextImpl());
		//
		doPerform("Test5",new ContextImpl(5));
		//
		doPerform("Test5",new ContextImpl(new String[] {"A","B"},new String[] {"D","E"},6));
		//
	}
	
	public static void main(String[] args) {
		junit.textui.TestRunner.run(WorkspaceMessageTester.class);
	}

	
}
