package nl.moj.test.junit.dummy;

import nl.moj.client.anim.Anim;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Tester;
import nl.moj.model.Workspace;
import nl.moj.model.Tester.TestResult;
import nl.moj.process.ProcessPool.ProcessListener;

/**
 * 
 */
public class DummyOperation implements Operation,Runnable,Team.TestResults {

	private boolean sub,success;
	private int length;
	private ProcessListener lst;

	public DummyOperation(boolean sub,boolean success,int length) {
		this.sub=sub;
		this.length=length;
		this.success=success;
	}
    public String getName() {
        return "DummyOp";
    }
	public String getTooltip() {
    	return "DummyOp";
	}
	public boolean isSubmit() {
    	return sub;
	}
	public boolean needsConfirm() {
	    return sub;
	}
	public void perform(Workspace.Internal team, ProcessListener lst,Context ctx) {
		this.lst=lst;
		new Thread(this).start();
	}
	public void run() {
		lst.queued(this);
		try {
			Thread.sleep(length/2);
		} catch (InterruptedException ex) {
		}
		lst.executing(this);
		try {
			Thread.sleep(length/2);
		} catch (InterruptedException ex) {
		}
		lst.complete(this);
		//
	}
	public Operation getOperation() {
		return this;
	}
    public TestResult getTestResults() {
        return new Tester.TestResult() {
            public int[] getResults() {
            	if (success) return new int[] { Tester.TestResult.PASS };
                		else return new int[] { Tester.TestResult.FAIL };
            }
			public boolean[] getScore() {
				return new boolean[] { success };
			}
			public boolean isFaulty() {
				return !success;
			}
			public boolean isOk() {
				return success;
			}
			public boolean isUnknown() {
				return false;
			}
			public Anim[] getAnimationOutput() {
				return new Anim[1];
			}
        };
    }



}
