package nl.moj.test.junit.dummy;

import java.util.ArrayList;
import java.util.List;

import nl.moj.model.Clock;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;

/**
 * 
 */
public class DummyClock implements Clock {

	private static final int DURATION=30*60;

	private List myNoti=new ArrayList();
	private int min,sec;
	private boolean started,running;

    public void addNotifier(Notification nf) {
		myNoti.add(nf);
    }
	public int getDuration() {
		return DURATION;
	}
	public int getSecondsPassed() {
		return min*60+sec;
	}
	public boolean isFinished() {
		return getSecondsPassed()>=DURATION;
	}
	public boolean isRunning() {
		return running;
	}
	public boolean isStarted() {
		return started;
	}	
	public void load(Round rnd,Team tm, State s) {
		//
	}
	public void reset() {
		running=false;
		started=false;
		min=0;
		sec=0;
	}
	public void start() {
		started=true;
		running=true;
	}
	public void stop() {
		running=false;
	}
	public boolean isStartPosition() {
		return ((min==0)&&(sec==0)&&(!started));
	}
	public void run() {
		
	}
	public int getDurationInMinutes() {
		return DURATION/60;
	}
	public int getSecondsRemaining() {
		return DURATION-getSecondsPassed();
	}
	
	//
	// Test Methods
	//
	
	public void fireClockStarted() {
		for (int t=0;t<myNoti.size();t++) 
			((Notification)myNoti.get(t)).clockStarted();
	}
	public void fireMinutePassed(int min) {
		for (int t=0;t<myNoti.size();t++) 
			if (min==DURATION) {
				((Notification)myNoti.get(t)).clockFinished();
			} else {
				((Notification)myNoti.get(t)).minutePassed(min);
			}
	}
	public void fireClockStopped() {
		for (int t=0;t<myNoti.size();t++) 
			((Notification)myNoti.get(t)).clockStopped();
	}	
	public void fireClockFinished() {
		for (int t=0;t<myNoti.size();t++) 
			((Notification)myNoti.get(t)).clockFinished();
	}	
	public void fireClockReset() {
		for (int t=0;t<myNoti.size();t++) 
			((Notification)myNoti.get(t)).clockReset();
	}	
	
	public void setTime(int mn,int sec) {
		this.min=mn;
		this.sec=sec;	
	}


}
