package nl.moj.test.junit.dummy;

import java.io.IOException;
import java.io.InputStream;

import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Tester.SecurityDelegate;
import nl.moj.security.DefaultSecurityDelegate;

/**
 * 
 */
public class DummyAssignment implements Assignment {
	
	private String name;
	private Operation[] myOps;
	private SecurityDelegate defaultDelegate;
	
	public DummyAssignment() {
		myOps=new Operation[] {
			// Ordinary Op
			new DummyOperation(false,false,100),
			// Submit that succeeds 
			new DummyOperation(true ,true,100),
			// Submit that fails
			new DummyOperation(true ,false,100)
		};
		//		
		name="TestRound";
		defaultDelegate=new DefaultSecurityDelegate();
		// 
	}
	
	public DummyAssignment(String name,SecurityDelegate sd) {
		this();
		this.name=name;
		this.defaultDelegate=sd;
	}
	
    public InputStream getAssignmentFileData(String name) throws IOException {
        throw new IOException("Dummy Assignment - No Files");
    }
	public String[] getDescriptionFileNames() {
		return new String[0];
	}
	public String[] getEditableFileNames() {
		return new String[0];
	}
	public String getName() {
		return name;
	}
	public String getDisplayName() { return getName(); }
	public Operation[] getOperations() {
		return myOps;
	}
	public String[] getSourceCodeFileNames() {
		return new String[0];
	}
	public boolean isDescriptionRenderedInMonospaceFont() {
		return false;
	}
	public SecurityDelegate getSecurityDelegate() {
        return defaultDelegate;
    }

	public String getAuthor() {
		return null;
	}
	public byte[] getIcon() {
		return null;
	}
	public byte[] getSponsorImage() {
		return null;
	}
	public String getSubmitClass() {
		return "Dummy";
	}
	public int getSubmitClassTimeout() {
		return 25;
	}
	public String getTestClass() {
		return "Dummy";
	}
	public int getTestClassTimeout() {
		return 15;
	}
	public int getDuration() {
		return 30;
	}
	
}
