package nl.moj.test.junit;

import java.io.File;

import junit.framework.TestCase;
import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.model.Assignment;
import nl.moj.model.Tester.SecurityDelegate;
import nl.moj.security.DefaultSecurityDelegate;
import nl.moj.security.NoSecurityDelegate;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.junit.dummy.DummyAssignment;

public class SandboxSecurtyManagerMultiAssignmentTest extends TestCase {

	public static class X6SSM extends SandboxSecurityManager {
		public X6SSM(ThreadGroup evil) {
			super(evil);
		}
		@Override
		public SecurityDelegate getSecurityDelegate(ThreadGroup tg) {
			return super.getSecurityDelegate(tg);
		}
	};
	public static class SneakyOp implements Runnable {
		public Throwable x;
		public void run() {
			try {
				new File("c:/pindakaas.txt").delete();
			} catch (Throwable ex) {
				x=ex;
			}
		}
		public Throwable getThrowable() { return x; }
	}
	
	// Create the Evil Threadgroup - all threads in this group are potentially evil and must be checked !
	public static final ThreadGroup evil=new ThreadGroup("evil");
	
	private X6SSM ssm;
	
	public void setUp() {
		SimpleLogFormatter.clearLogConfig();
		ssm=new X6SSM(evil);	
		System.setSecurityManager(ssm);
	}
	
	public void testRegisterAssignment() {
		Assignment a1=new DummyAssignment("One",new DefaultSecurityDelegate());
		ssm.registerAssignment(a1);
		ThreadGroup tg=ssm.getEvilThreadGroup(a1);
		//
		assertTrue(tg.getName().startsWith(a1.getName()));
		assertEquals(evil,tg.getParent());
		assertEquals(a1.getSecurityDelegate(),ssm.getSecurityDelegate(tg));
	}
	public void testRegisterTwoAssignments() {
		Assignment a1=new DummyAssignment("One",new DefaultSecurityDelegate());
		Assignment a2=new DummyAssignment("Two",new NoSecurityDelegate());
		ssm.registerAssignment(a1);
		ssm.registerAssignment(a2);
		ThreadGroup tg1=ssm.getEvilThreadGroup(a1);
		ThreadGroup tg2=ssm.getEvilThreadGroup(a2);
		//
		assertTrue(tg1.getName().startsWith(a1.getName()));
		assertEquals(evil,tg1.getParent());
		assertEquals(a1.getSecurityDelegate(),ssm.getSecurityDelegate(tg1));
		//
		assertTrue(tg2.getName().startsWith(a2.getName()));
		assertEquals(evil,tg2.getParent());
		assertEquals(a2.getSecurityDelegate(),ssm.getSecurityDelegate(tg2));
		//
		// Now see if it really works !
		//
		SneakyOp snop1=new SneakyOp();
		SneakyOp snop2=new SneakyOp();
		new Thread(tg1,snop1).start();
		new Thread(tg2,snop2).start();
		// Wait a bit.
		try { Thread.sleep(500); } catch (InterruptedException ex) { }
		//
		// Should not allow
		//
		assertNotNull(snop1.getThrowable());
		assertTrue(snop1.getThrowable() instanceof SecurityException);
		//
		// Should allow.
		//
		assertNull(snop2.getThrowable());
		//
	}
	
}
