package nl.moj.test.junit;

import nl.moj.test.client.AnimTest;
import nl.moj.test.junit.workspace.RemoteWorkspaceTester;
import nl.moj.test.junit.workspace.WorkspaceMessageTester;
import nl.moj.test.junit.workspace.WorkspaceTester;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllTests {

    public static Test suite() {
        TestSuite suite = new TestSuite("MojTests");
        // Assignments
        suite.addTestSuite(JarAssignmentTest.class);
        // Components
        suite.addTestSuite(SandboxSecurityManagerTest.class);
        suite.addTestSuite(SandboxSecurtyManagerMultiAssignmentTest.class);
        suite.addTestSuite(FriendlySecurityDelegateTest.class);
        suite.addTestSuite(ProcessPoolTest.class);
        // Client
        suite.addTestSuite(AnimTest.class);
        // Client IO
        suite.addTestSuite(ProtocolTest.class);
        suite.addTestSuite(ClientServerTest.class);
        // Game
        suite.addTestSuite(RoundImplTest.class);
        suite.addTestSuite(TeamTest.class);
        suite.addTestSuite(TesterTest.class);
        suite.addTestSuite(CompetitionGameRulesTest.class);
        suite.addTestSuite(ScoringRulesTest.class);
        suite.addTestSuite(MoJ2005ScoringRulesTest.class);
        // (Remote) Workspace
        suite.addTestSuite(WorkspaceMessageTester.class);
        suite.addTestSuite(WorkspaceTester.class);
        suite.addTestSuite(RemoteWorkspaceTester.class);
        //
        return suite;
    }

    /**
     * Runs the test suite using the text runner.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
}
