package nl.moj.test.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JFrame;

import nl.moj.client.Sheep;
import nl.moj.client.anim.AnimPlayer;
import nl.moj.client.anim.LayeredAnim;

/**
 * 
 */
public class LayeredAnimTestIU {

	public static LayeredAnim createAnim() {
		LayeredAnim a=new LayeredAnim();
		//
		LayeredAnim.BitMapResource sheep=a.createBitmapResource();		
		sheep.setImageData(Sheep.whiteSheepColors,Sheep.pixels);
		//
		LayeredAnim.BitMapResource blackSheep=a.createBitmapResource();		
		blackSheep.setImageData(Sheep.blackSheepColors,Sheep.pixels);
		//
		LayeredAnim.ShapeResource grass=a.createShapeResource().set(LayeredAnim.ShapeResource.SHAPE_RECT,new Color(0xE0FFE0),(short)100,(short)100);
		//
		LayeredAnim.AnimFrame current=a.createNewFrame();
		for (int t=0;t<100;t++) {
			current.add(grass,0,0,0);
			current.add(sheep,t,t,t*4);
			current.add(blackSheep,100-t,100-t,t*4);
			current=a.createNewFrame();
		}
		//		
		for (int t=0;t<360;t+=10) {
			current=a.createNewFrame();
			current.add(grass,0,0,0);
			current.add(sheep,100-t/4,100-t/4,t);
		}
		//
		return a;
	} 
	
	public static LayeredAnim createMapAnim() {
		LayeredAnim a=new LayeredAnim();
		LayeredAnim.ShapeResource s1=a.createShapeResource();
		LayeredAnim.ShapeResource s2=a.createShapeResource();
		LayeredAnim.MapResource map=a.createMapResource();
		//
		s1.set(LayeredAnim.ShapeResource.SHAPE_RECT,Color.RED,(short)8,(short)8);
		s2.set(LayeredAnim.ShapeResource.SHAPE_RECT,Color.GREEN,(short)8,(short)8);
		Map c2s=new HashMap();
		c2s.put(new Character('x'),new Short(s1.getId()));
		c2s.put(new Character('X'),new Short(s2.getId()));
		map.setMap(8,new String[] { "xXxXx","XxXxX","xXxXx" },c2s);
		//
		LayeredAnim.AnimFrame f1=a.createNewFrame();
		f1.add(map,0,0,0);
		//
		LayeredAnim.AnimFrame f2=a.createNewFrame();
		f2.add(map,8,8,0);
		//
		LayeredAnim.AnimFrame f3=a.createNewFrame();
		f3.add(map,16,16,0);
		//
		return a;		
	}

	public static void main(String[] args) throws IOException {
		//
		AnimPlayer trd1=new AnimPlayer();
		//
		JFrame f=new JFrame();
		f.setSize(512,512);
		f.getContentPane().add(trd1,BorderLayout.CENTER);
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		//
		LayeredAnim a=createMapAnim();
		//
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		DataOutputStream oos = new DataOutputStream(baos);
		a.write(oos);
		//
		byte[] recordInBytes = baos.toByteArray();
		//
		System.out.println("Size = "+recordInBytes.length);
		//
		ByteArrayInputStream bais = new ByteArrayInputStream(recordInBytes);
		DataInputStream ois = new DataInputStream(bais);
		//
		LayeredAnim copy=new LayeredAnim();
		copy.read(ois);		
		//
		trd1.setAnimation(copy);
		//
		f.setVisible(true);
		//
	}

}
