package nl.moj.client.codecompletion;

import java.util.Stack;

import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.FieldStatement;
import nl.moj.client.codecompletion.statement.ImportStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.MethodStatement;
import nl.moj.client.codecompletion.statement.StatementVisitor;

/**
 * Source Code Completion identifies possible identifiers that can be used  
 */
public class SourceCodeCompletion implements CompletionSource {

	private SourceCodeParser mySource;

    public SourceCodeCompletion(String sourceCode) {
    	//
		mySource=new SourceCodeParser(sourceCode);
    	//
    }
    
	public SourceCodeCompletion(SourceCodeParser scc) {
		mySource=scc;
	}
    
    public void addToCodeTree(final CodeNodeFactory cnf, CodeNode root) {
		JavaFile f=mySource.getJavaFile();
		//
		ImportStatement[] istm=f.getImports();
		for (int t=0;t<istm.length;t++) {
			if (istm[t].isWildcard()) continue;
			new TypeCodeCompletion(istm[t].getImport()).addToCodeTree(cnf,root);
		}
		//
		String pkg=f.getPackage().getPackage();
		final CodeNode base=cnf.addDotSeparated(pkg,root);
		//
		mySource.visit(new StatementVisitor() {
			private Stack stack=new Stack();
			public void begin() {
				stack.push(base);
			}
			public void beginStatement(AbstractStatement st, int indent, boolean isLast) {
				CodeNode current=(CodeNode)stack.peek();
				if (st.isClassStatement()) {
					String name=st.getName();
					stack.push(cnf.addIfNotExist(current,name.substring(name.lastIndexOf('.')+1),true));
				} else if (st.isInterfaceStatement()) {
					stack.push(cnf.addIfNotExist(current,st.getName(),true));
				} else if (st.isMethodStatement()) {
					cnf.addReferenceIfNotExist(current,st.getName(),((MethodStatement)st).getType(),((MethodStatement)st).isStatic());
				} else if (st.isFieldStatement()) {
					cnf.addReferenceIfNotExist(current,st.getName(),((FieldStatement)st).getType(),((FieldStatement)st).isStatic());
				}				
			}
			public void onStatement(AbstractStatement st, int indent, boolean isLast) {
				if (stack.isEmpty()) return;
				CodeNode current=(CodeNode)stack.peek();
				if (st.isMethodStatement()) {
					cnf.addReferenceIfNotExist(current,st.getName(),((MethodStatement)st).getType(),((MethodStatement)st).isStatic());
				} else if (st.isFieldStatement()) {
					cnf.addReferenceIfNotExist(current,st.getName(),((FieldStatement)st).getType(),((FieldStatement)st).isStatic());
				}				
			}
			public void endStatement(AbstractStatement st, int indent, boolean isLast) {
				if (st.isClassStatement()) {
					stack.pop();
				} else if (st.isInterfaceStatement()) {
					stack.pop();
				}
			}
			public void end() {}
		});	
    }
	
	public static void main(String[] args) {
		String source="package nl.bla;" +
					  "import java.util.List;"+
			  		  "import java.util.ArrayList;"+
					  "public class Wodka extends Object implements List {" +
					  " public static final String RATATA=\"RATATA\";"+
					  " public void getBanana() {" +
					  "  List myBanana=new ArrayList(); "+
					  "  for (int t=0;t<10;t++) {" +
					  "     myBanana.add(new Integer(t));" +
					  "  }"+
					  "  return myBanana;"+ 
					  " } "+
					  " /* dfksfpoks */"+
					  " public interface Visitor {"+
					  "  public void begin(Object o);" +
					  "  public void end(Object o);"+
					  " }"+
					  "}";
		/*		SourceCodeParser scc=new SourceCodeParser(source);
		scc.visit(new StatementVisitor() {
			public void begin() {
				//
			}
			public void beginStatement(AbstractStatement st, int indent, boolean isLast) {
				for (int t=0;t<indent;t++) System.out.print(".");
				if ((st instanceof ClassStatement)) {
					System.out.println(st+" { \t"+((ClassStatement)st).getFullyQualifiedName());
				} else if (st instanceof InterfaceStatement) {
					System.out.println(st+" { \t"+((InterfaceStatement)st).getFullyQualifiedName());
				} else {
					System.out.println(st+" { \t"+st.getClass().getName());
				}
            }
			public void onStatement(AbstractStatement st, int indent, boolean isLast) {
				for (int t=0;t<indent;t++) System.out.print(".");
				System.out.println(st+" \t"+st.getClass().getName());
			}
			public void endStatement(AbstractStatement st, int indent, boolean isLast) {
				for (int t=0;t<indent;t++) System.out.print(".");
				System.out.println("}");
			}
			public void end() {
				//
			}
		});
		System.out.println(scc.getJavaFile().containsImport("nl.bla.Wodka"));
*/		
		CodeNodeFactory cnf=new CodeNodeFactory();
		CodeNode root=cnf.createRoot();
		SourceCodeCompletion tcc=new SourceCodeCompletion(source);
		tcc.addToCodeTree(cnf,root);
		System.out.println(root.render());
	}

}
