package nl.ctrlaltdev.sound;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

import javax.sound.sampled.*;

/**
 * @author E.Hooijmeijer / (C) 2003-2005 E.Hooijmeijer / Licence : LGPL 2.1
 * 28-04-2005 : added optional delay to compensate for bug 4434125 
 */

public class SoundPlayer {

	public class SoundPlayerException extends Exception {
		public SoundPlayerException(String s) { super(s); }
	}
	
	private Mixer myMixer;
	private Timer soundStopper;
	private long closeAfterStopDelay;

	public SoundPlayer() throws SoundPlayerException {
		Mixer.Info[] mi=AudioSystem.getMixerInfo();		
		if (mi.length==0) throw new SoundPlayerException("No Audio Hardware available.");
		myMixer=AudioSystem.getMixer(mi[0]);
	}
	
	public SoundPlayer(long closeAfterStopdelay) throws SoundPlayerException {
		this();
		soundStopper=new Timer(true);
		this.closeAfterStopDelay=closeAfterStopdelay;
	}	
	
	public void play(File aFile) throws SoundPlayerException {
		if (aFile==null) throw new NullPointerException("The file is NULL.");
		if (!aFile.exists()) throw new SoundPlayerException("File "+aFile+" does not exist.");
		try {
			AudioFormat format=AudioSystem.getAudioFileFormat(aFile).getFormat();
			//			
			DataLine.Info info = new DataLine.Info(Clip.class, format); 
			//
		    final Clip line = (Clip) myMixer.getLine(info);
		    line.open(AudioSystem.getAudioInputStream(aFile));
			//
			line.addLineListener(new LineListener() {
				public void update(LineEvent le) {
					//
					// See BUG 4434125 for the reason of this rather interesting delay.
					//
					if (le.getType().equals(LineEvent.Type.STOP)) {
						if (soundStopper!=null) {
							soundStopper.schedule(new TimerTask() {
    	                        public void run() {
									line.close();
            	                }
							},closeAfterStopDelay);
						} else {
							line.close();
						}
					}
				}
			});
			//
			line.start();
			//
		} catch (Exception e) {
			throw new SoundPlayerException("Unable to play sample : "+e);
		}
	}
	
	public static void main(String[] args) throws Throwable {
		new SoundPlayer(200).play(new File("D:\\music\\wav\\ss2\\shodan\\shodan asterisk.wav"));
	}

}

