import java.io.File;
import java.io.IOException;

import nl.moj.workspace.factory.RemoteWorkspaceFactory;
import nl.ctrlaltdev.io.OutputRedirector.Target;
import nl.moj.assignment.JarFileAssignment;
import nl.moj.model.Operation;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.process.ProcessPool.ProcessListener;
import nl.moj.security.SandboxSecurityManager;

/**
 * TestWorkspaceServer : example implementation on how to use the Workspace Server.
 * @author E.Hooijmeijer
 */
public class TestWorkspaceServer {

	// very stupid command synchronization flag. Just to show that it workds. 
	public static boolean ready=true;
	
	//
	// starts the updated Thread. Is used to read incoming messages asynchronously.
	//
	private static void startUpdater(final Workspace ws) {
		Thread updater=new Thread(new Runnable() {
			public void run() {
				while (true) {
					try {
						ws.update();
					} catch (IOException ex) {
						ex.printStackTrace();
					}
					try {
						Thread.sleep(100);
					} catch (InterruptedException ex) {
						// Ignore.
					}
				}
			}
		});
		updater.setDaemon(true);
		updater.start();
	}
	
	public static void main(String[] args) throws Throwable {
		//
		// Setup security manager and evil threadgroup. 
		// Should not be neccecary. However... 
		//
		ThreadGroup evilThreadGroup=new ThreadGroup("evil");
		//
		System.setSecurityManager(new SandboxSecurityManager(evilThreadGroup));
		//
		// Create the new RemoteWorkspaceFactory that connects to the Workspace server.
		//
		RemoteWorkspaceFactory factory=new RemoteWorkspaceFactory("127.0.0.1",8081);
		//
		// Setup the workspace.
		// - the name is the name of the workspace. Must be unique. Is used to create the workspace folder.
		// - Target is a redirection of the std output and std error of the process. Anything that gets
		//   System.out.println'ed will appear here.
		// - ProcessListener will notify you of the progress of any Operations that are being executed.
		//   There can be only one operation running at the same time (for obvious reasons) 
		//
		Workspace ws=factory.createWorkspace("JavaBlackBelt",new Target() {
			public void append(String context, String s) {
				System.out.println(context+" : "+s);			
			}
		},new ProcessListener() {
			public void queued(Runnable r) {
				System.out.println("Queued : "+r);
			}
			public void executing(Runnable r) {
				System.out.println("Executing : "+r);
			}
			public void complete(Runnable r) {
				System.out.println("Complete : "+r);
				ready=true;
			}
		});
		//
		try {
			//
			// Loads the assignment.
			//
			ws.loadAssignment(new JarFileAssignment(new File("./data/cases/haikuCase.jar"),null,null),false);
			//
			// Get the filenames in the assignment.
			//
			String[] fileNames=ws.getEditorFiles();
			String[] contents=new String[fileNames.length];
			//
			String   fileNameToEdit=null;
			String   fileContentsToEdit=null;
			//
			// Display some useful information about the files.
			//
			for (int t=0;t<fileNames.length;t++) {
				contents[t]=ws.getContents(fileNames[t]);
				System.out.println(fileNames[t]+" : ");
				System.out.println(" is java file  : "+ws.isJava(fileNames[t]));
				System.out.println(" is monospaced : "+ws.isMonospaced(fileNames[t]));
				System.out.println(" is readonly   : "+ws.isReadOnly(fileNames[t]));
				System.out.println(" size          : "+contents[t].length());
				//
				// Find out which one can be edited by the user. 
				// 
				if ((!ws.isReadOnly(fileNames[t]))&&(ws.isJava(fileNames[t]))) {
					fileNameToEdit=fileNames[t];
					fileContentsToEdit=contents[t];
				}
			}
			//
			if (fileNameToEdit==null) throw new NullPointerException("Assignment has no editable file ?!");
			//
			// Start the updater Thread that reads incoming messages from the server.
			// Note that any blocking commands (such as getContents()) should not be 
			// executed while this Thread is running. 
			// 
			startUpdater(ws);			
			//
			// Get the Operations that can be applied to the Workspace.
			//
			Operation save=ws.getOperationByName("Save");
			Operation compile=ws.getOperationByName("Compile");
			Operation test=ws.getOperationByName("Test");
			Operation submit=ws.getOperationByName("Submit");			
			//
			// Save the file using the Context (a container for files and other operation info)
			//
			ready=false;
			ws.perform(save,new ContextImpl(fileNameToEdit,fileContentsToEdit,Operation.IDX_EVERYTHING));			
			//
			// Wait until the operation has finished.
			//
			while (!ready) try {
				Thread.sleep(1000);
			} catch (InterruptedException ex) {
				// Ignore.
			}
			//
			// Save and Compile the file
			//
			ready=false;
			ws.perform(compile,new ContextImpl());
			//
			// Wait until the operation has finished.
			//
			while (!ready) try {
				Thread.sleep(100);
			} catch (InterruptedException ex) {
				// Ignore.
			}			
			//
			// Save and Compile and Test the file
			// In this case the Context says that it may only test the first test.
			//
			ready=false;
			ws.perform(test,new ContextImpl(0));
			//
			// Wait until the operation has finished.
			//
			while (!ready) try {
				Thread.sleep(100);
			} catch (InterruptedException ex) {
				// Ignore.
			}
			//
			// Save and Compile and Test and Score the file
			//
			ready=false;
			ws.perform(submit,new ContextImpl(fileNameToEdit,fileContentsToEdit,Operation.IDX_EVERYTHING));
			//
			while (!ready) try {
				Thread.sleep(100);
			} catch (InterruptedException ex) {
				// Ignore.
			}			
			//			
		} finally {
			//
			// Delete the workspace.
			// Alternatively use ws.suspend() to suspend the workspace and continue later.
			//
			ws.dispose();
			//
		}
		//
	}
	
}
